/*!
  jquery.psPager.js - jQueryプラグイン
*/
(function($){
	$.fn.psPager = function(options) {
		var defaults = {  
			firstArrow : "先頭頁",  
			prevArrow : "前頁",
			lastArrow : "最終頁",
			nextArrow : "次頁",
			pgselAfterText : '件/頁',
			rowsPerPage : 25,
			currPage : 1,
			optionsForRows : [5,10,25,50,100],
			ignoreRows : [],
			topNav : true,
			uiNav : true
		};  
		settings = $.extend(defaults, options);
		
		return this.each(function() {
      var table = $(this)[0],
          totalPagesId  = '#psPager_totalPages',
          currPageId    = '#psPager_currPage',
          rowsPerPageId = '#psPager_rowsPerPage',
          firstPageId   = '#psPager_firstPage',
          prevPageId    = '#psPager_prevPage',
          nextPageId    = '#psPager_nextPage',
          lastPageId    = '#psPager_lastPage',
          myCanvas      = "#psPagerCanvas",
          tblLocation = (settings.topNav) ? "prev" : "next",
          possibleTableRows = $.makeArray($('tbody tr', table)),
          tableRows = $.grep(possibleTableRows, function(value, index) { return ($.inArray(value, settings.ignoreRows) == -1);}, false),
          numRows = tableRows.length,
          totalPages = resetTotalPages(),
          currPageNumber = (settings.currPage > totalPages) ? 1 : settings.currPage,
          hideOtherPages = function(pageNum) { // カレント以外のページを隠す
            if (pageNum==0 || pageNum > totalPages) return;
            var startIndex = (pageNum - 1) * settings.rowsPerPage,
                endIndex = (startIndex + settings.rowsPerPage - 1);
            $(tableRows).show();
            for (var i=0;i<tableRows.length;i++) {
              if (i < startIndex || i > endIndex) { $(tableRows[i]).hide() }
            }
          };
      if ($.inArray(settings.rowsPerPage, settings.optionsForRows) == -1) settings.optionsForRows.push(settings.rowsPerPage);
      // function hideOtherPages(pageNum) { // カレント以外のページを隠す
      //   if (pageNum==0 || pageNum > totalPages) return;
      //   var startIndex = (pageNum - 1) * settings.rowsPerPage,
      //       endIndex = (startIndex + settings.rowsPerPage - 1);
      //   $(tableRows).show();
      //   for (var i=0;i<tableRows.length;i++) {
      //     if (i < startIndex || i > endIndex) { $(tableRows[i]).hide() }
      //   }
      // }
      function resetTotalPages() {
        var preTotalPages = Math.round(numRows / settings.rowsPerPage),
            totalPages = (preTotalPages * settings.rowsPerPage < numRows) ? preTotalPages + 1 : preTotalPages;
        if ($(table)[tblLocation]().find(totalPagesId).length > 0) $(table)[tblLocation]().find(totalPagesId).html(totalPages);
        return totalPages;
      }
      function resetCurrentPage(currPageNum) {
        if (currPageNum < 1 || currPageNum > totalPages) return;
        currPageNumber = currPageNum;
        hideOtherPages(currPageNumber);
        $(table)[tblLocation]().find(currPageId).val(currPageNumber)
      }
      function resetPerPageValues() {
        var isRowsPerPageMatched = false,
            optsPerPage = settings.optionsForRows,
            perPageDropdown = $(table)[tblLocation]().find(rowsPerPageId)[0];
        optsPerPage.sort(function (a,b){return a - b;});
        perPageDropdown.length = 0;
        for (var i=0;i<optsPerPage.length;i++) {
          if (optsPerPage[i] == settings.rowsPerPage) {
            perPageDropdown.options[i] = new Option(optsPerPage[i], optsPerPage[i], true, true);
            isRowsPerPageMatched = true;
          }else{
            perPageDropdown.options[i] = new Option(optsPerPage[i], optsPerPage[i]);
          }
        }
        if( !isRowsPerPageMatched ) settings.optionsForRows == optsPerPage[0];
      }
			function createPaginationElements() {
				var html = "<div id='psPager'>"
					+"<span id='psPager_perPage'>"
						+"<select id='psPager_rowsPerPage'>"
							+"<option value='"+settings.rowsPerPage+"'>"+settings.rowsPerPage+"</option>"
						+"</select>"+settings.pgselAfterText
					+"</span>"
					+"<span id='psPager_paginater'>"
						+"<button id='psPager_firstPage' class='btn'>"+settings.firstArrow+"</button>"
						+"<button id='psPager_prevPage' class='btn'>"+settings.prevArrow+"</button>"
						+"<span id='psPager_valPage'>&nbsp;"
							+"<input id='psPager_currPage' type='input' value='"+currPageNumber+"' size=1>"
						+"</span>"
						+" / <span id='psPager_totalPages'>"+totalPages+"</span>&nbsp;"
						+"<button id='psPager_nextPage' class='btn'>"+settings.nextArrow+"</button>"
						+"<button id='psPager_lastPage' class='btn'>"+settings.lastArrow+"</button>"
					+"</span></div>";
				return html;
			}
			// 表示 ... #psPager_totalPages が無ければ topNav によって前か後に表示、あればその位置に表示
			if ($(table)[tblLocation]().find(totalPagesId).length == 0){
				if (settings.topNav) {
					$(this).before(createPaginationElements());
				}else{
					$(this).after(createPaginationElements());
				}
			}else{
				$(table)[tblLocation]().find(currPageId).val(currPageNumber);
			}
			// $ UI
			if( settings.uiNav ){
				$(table)[tblLocation]().find(firstPageId).button({icons:{primary:"ui-icon-seek-start"}, text:false});
				$(table)[tblLocation]().find(prevPageId).button({icons:{primary:"ui-icon-seek-prev"}, text:false});
				$(table)[tblLocation]().find(nextPageId).button({icons:{primary:"ui-icon-seek-next"}, text:false});
				$(table)[tblLocation]().find(lastPageId).button({icons:{primary:"ui-icon-seek-end"}, text:false});
			}
			//
			resetPerPageValues();
			hideOtherPages(currPageNumber);
			//
			$(table)[tblLocation]().find(firstPageId).bind('click', function (e) { resetCurrentPage(1) });
			$(table)[tblLocation]().find(prevPageId).bind('click', function (e) { resetCurrentPage(currPageNumber - 1) });
			$(table)[tblLocation]().find(nextPageId).bind('click', function (e) { resetCurrentPage(parseInt(currPageNumber) + 1) });
			$(table)[tblLocation]().find(lastPageId).bind('click', function (e) { resetCurrentPage(totalPages) });
			$(table)[tblLocation]().find(currPageId).bind('change', function (e) { resetCurrentPage(this.value) });
			$(table)[tblLocation]().find(rowsPerPageId).bind('change', function (e) {
				settings.rowsPerPage = parseInt(this.value, 10);
				totalPages = resetTotalPages();
				resetCurrentPage(1)
			});
		})
	};		
})(jQuery);