<?php
class mysqlite3 extends SQLite3 {
	var $sys;
	function __construct($db_fn=""){
		//$d = debug_backtrace(); // 呼び出し元の情報
		//$this->sys['setfile'] = dirname($d[0]["file"])."/tables.sql";
		//$this->sys['dbfile'] = $db_fn;
		//$this->open($db_fn);
		//// テーブルが無ければ、設定情報を元にテーブル・インデックスを作成
		//if(count($this->tables())==0) $this->_init();
	}
	function _test(){
		$d0 = debug_backtrace();
		$callfn = $d0[0]["file"];
		$ret = "db_file ... ".$this->sys['dbfile']."<br>"
			 . "call_file ... ".$callfn;
		return $ret;
	}
	//
	// UPDATE ... 更新
	//
	function update($table, $newData, $whereStr){
		$sql = $this->updateSql($table, $newData, $whereStr);
    $this->sys['last_sql'] = $sql;
		return @$this->exec($sql);
	}
	function updateSql($table, $newData, $whereStr){
		foreach($newData as $k=>$v) $d[] = $k."='".$v."'";
		$set = implode(",", $d);
		return "UPDATE {$table} SET {$set} WHERE {$whereStr};";
	}
	//
	// DELETE ... 削除
	//
	function delete($table, $whereStr){
	  $sql = $this->deleteSql($table, $whereStr);
    $this->sys['last_sql'] = $sql;
		return @$this->exec($sql);
	}
	function deleteSql($table, $whereStr){
	    return "DELETE FROM {$table} WHERE ".$whereStr.";";
	}
	function deleteAll($table){
    $sql = 'DELETE FROM '.$table;
    $this->sys['last_sql'] = $sql;
		return @$this->exec($sql);
	}
	//
	// INSERT ... 挿入
	//
	function insert($table, $newData){
		$sql = $this->insertSql($table, $newData);
    $this->sys['last_sql'] = $sql;
		return $this->exec($sql);
	}
	function insertSql($table, $newData){
		foreach($newData as $key=>$val){ $fields[] = $key; $values[] = $val;}
		$f = implode(",", $fields);
		$v = "'".implode("','", $values)."'";
		return "INSERT INTO {$table} ({$f}) VALUES({$v});";
	}
	//
	// SELECT ... 抽出
	//
	function select($table, $whereStr="", $orderStr="", $rec="", $limit="", $addSQL="", $addField=""){
		$sql = $this->selectSql($table, $whereStr, $orderStr, $rec, $limit, $addSQL, $addField);
    $this->sys['last_sql'] = $sql;
		$fs = @$this->query($sql);
		$ret = array();
		while ($v = $fs->fetchArray(SQLITE3_ASSOC)) $ret[] = $v;
		if( $rec!=="" ) $ret = $ret[$rec];
		return $ret;
	}
	function selectSql($table, $whereStr="", $orderStr="", $rec="", $limit="", $addSQL="", $addField=""){
		if($whereStr!="") $wh = " WHERE ".$whereStr;
		if($orderStr!="") $od = " ORDER BY ".$orderStr;
		if($addSQL!="")   $ad = " ".$addSQL;
		if($limit!=""){
			list($num, $page) = explode(';', $limit);
			if($page=="" or $page=="0" or $page=="1"){
				$li = " LIMIT ".$num;
			}else{
				$of = (intval($page) - 1) * $num;
				$li = " LIMIT ".$num." OFFSET ".$of;
			}
		}
		return "SELECT *{$addField} FROM {$table}{$ad}{$wh}{$od}{$li};";
	}
	//
	// DISTINCT ... 重複しない値を抽出
	//
	function distinct($table, $field){
		$sql = "SELECT DISTINCT {$field} FROM {$table}";
    $this->sys['last_sql'] = $sql;
		$fs = @$this->query($sql);
		$ret = array();
		while ($v = $fs->fetchArray(SQLITE3_ASSOC)) $ret[] = $v[$field];
		return $ret;
	}
	//
	// group ... グループ化して、値名(na)とそのデータ数(su)を返す
	//
	function group($table, $field, $where="", $order=""){
		$sql = $this->groupSql($table, $field, $where, $order);
    $this->sys['last_sql'] = $sql;
		$fs = @$this->query($sql);
		$ret = array();
		while ($v = $fs->fetchArray(SQLITE3_ASSOC)) $ret[] = $v;
		return $ret;
	}
	function groupSql($table, $field, $where="", $order=""){
		$sql = "SELECT {$field} AS na, count(*) AS su FROM {$table} GROUP BY {$field}";
		if($where!="") $sql .= ' HAVING '.$where;
		if($order!="") $sql .= ' ORDER BY '.$order;
		return $sql;
	}
	//
	// ym ... 日付でグループ化して、値名(na)とそのデータ数(su)を返す
	//
	function ym($table, $where="", $field='ymd', $order="", $fmt='%Y-%m'){
		$s = "strftime('{$fmt}', {$field}, 'unixepoch', 'localtime')";
		$sql = "SELECT {$s} AS na, count(*) AS su FROM {$table} GROUP BY na";
		if($where!="") $sql .= ' HAVING '.$where;
		if($order!="") $sql .= ' ORDER BY '.$order;
		$fs = $this->query($sql);
		$ret = array();
		while ($v = $fs->fetchArray(SQLITE3_ASSOC)) $ret[] = $v;
		return $ret;
	}
	//
	function cnt($tbl, $where=""){
		$sql = 'SELECT COUNT(*) AS cnt FROM '.$tbl;
		if($where!="") $sql .= " WHERE ".$where;
		$d = $this->sql($sql);
		return $d[0]['cnt'];
	}
	//
	// SQL文を指定して実行、結果を返す
	//
	function sql($sql){
		$fs = $this->query($sql);
		$ret = array();
		while ($v = $fs->fetchArray(SQLITE3_ASSOC)) $ret[] = $v;
		return $ret;
	}
	//
	// SQL文を指定して実行、結果を返さない
	//
	function sqlExec($sql){
    $this->sys['last_sql'] = $sql;
    return @$this->exec($sql);
  }
	//
	//
	//
	function begin(){ $this->exec("BEGIN DEFERRED;"); }
	function beginSql(){ return "BEGIN DEFERRED;"; }
	function rollback(){ $this->exec("ROLLBACK;"); }
	function rollbackSql(){ return "ROLLBACK;"; }
	function commit(){ $this->exec("COMMIT;"); }
	function commitSql(){ return "COMMIT;"; }
	function lastInsertID(){ return $this->lastInsertRowid(); }
	function vacuum(){ $this->exec("VACUUM;"); }
	//
	// フィールド追加
	//
	function addField($tableName, $addField, $addFieldType, $addPos, $createIndex=false){
		$tblCreateSQL = $this->table_info($tableName, 'sql'); // テーブル作成SQL文
		if( strpos($tblCreateSQL, $addField)!==false ) return 'exist';
		$idx = $this->indexes(); // 全index作成情報
		$tmpName = $tableName."_tmp";
		$sqlTmp = str_replace(array('CREATE', $tableName), array('CREATE TEMPORARY', $tmpName), $tblCreateSQL).";";
		$sqlNew = str_replace(",{$addPos}", ",{$addField} {$addFieldType},{$addPos}", $tblCreateSQL).";";
		// --------------
		$sql = array();
		$sql[] = "BEGIN DEFERRED;"; // トランザクション開始
		$sql[] = $sqlTmp; // 一時table作成
		$sql[] = "INSERT INTO {$tableName}_tmp SELECT * FROM {$tableName};"; // 一時テーブルに全データを追加 ...
		$sql[] = "DROP TABLE {$tableName};"; // テーブル削除
		$sql[] = $sqlNew; // 新テーブル作成
		if($createIndex) $sql[] = "CREATE INDEX idx_{$tableName}_{$addField} ON {$tableName}({$addField});";// index作成(オプション)
		foreach($idx as $v) $sql[] = $v.";"; // 既存の index を作成
		// 既存データを追加
		$f = explode(',', $this->field_names($tableName));
		foreach($f as $v){ if($v==$addPos){ $fld[] = 'NULL, '.$v;}else{ $fld[] = $v;} }
		$fldStr = implode(", ", $fld);
		$sql[] = "INSERT INTO {$tableName} SELECT {$fldStr} FROM {$tmpName};";
		$sql[] = "DROP TABLE {$tmpName};"; // 一時table削除
		$sql[] = "COMMIT;";
		// 実行
		foreach($sql as $s) $this->exec($s);
		return 'complete';
	}
	function addIndex($tableName, $fieldName){
		// テーブル情報
		$d = $this->table_info($tableName);
		$tblCreateSQL = $d['sql'];
		// index情報 ... 既にそのfieldのindexがあれば終了
		$idx = $this->indexes();
		$s = implode('', $idx); if( strpos($s, $tableName.'('.$fieldName.')')!==false ) return 'exist';
		// --------------
		$sql = array();
		// トランザクション開始
		$sql[] = "BEGIN DEFERRED;";
		// 対象テーブルと同じ内容の一時テーブルを作成 ... CREATE -> CREATE TEMPORARY / テーブル名 -> テーブル名_tmp
		$sql[] = str_replace(array('CREATE', $tableName), array('CREATE TEMPORARY', $tableName."_tmp"), $tblCreateSQL).";";
		// 一時テーブルに全データを追加 ...
		$sql[] = "INSERT INTO {$tableName}_tmp SELECT * FROM {$tableName};";
		// テーブル削除
		$sql[] = "DROP TABLE {$tableName};";
		// 新テーブル作成（構造は同じ）
		$sql[] = $tblCreateSQL.";";
		// 今回追加するフィールド用のindexを作成
		$sql[] = "CREATE INDEX idx_{$tableName}_{$fieldName} ON {$tableName}({$fieldName});";
		// 既存の index を作成
		foreach($idx as $v) $sql[] = $v.";";
		// 既存データを追加
		$sql[] = "INSERT INTO {$tableName} SELECT * FROM {$tableName}_tmp;"; // 7
		$sql[] = "DROP TABLE ".$tableName."_tmp;"; // 8
		$sql[] = "COMMIT;";
		// 実行
		foreach($sql as $s) $this->exec($s);
		return 'complete';
	}
	//	function checkIndex($tableName, $fieldName, $doMake=false){
	//		$s = implode('', $this->indexes());
	//		$ret = (strpos($s, $tableName.'('.$fieldName.')')===false) ? false : true;
	//		if( $doMake==true ){
	//			$s = "CREATE INDEX idx_{$tableName}_{$addField} ON {$tableName}({$addField});";
	//			return $this->exec($s);
	//		}else{
	//			return $ret;
	//		}
	//	}
	//
	// フィールド情報 ... mode=0:フィールド情報の配列　1:フィールド名をキーにした値が空白の配列　2:フィールド名のみの配列
	//
	function fields($tableName, $mode=0){
		$fs = $this->query('PRAGMA table_info('.$tableName.')');
		while ($v = $fs->fetchArray(SQLITE3_ASSOC)) {
			switch($mode){
				default: $ret[] = $v; break;			// フィールド情報の配列
				case 1:  $ret[$v['name']] = ''; break;	// フィールド名をキーにした、値が空白の連想配列
				case 2:  $ret[] = $v['name']; break;	// フィールド名の配列
			}
		}
		return $ret;
	}
	//
	// フィールド名をカンマ区切りで文字列として返す ... 廃止予定
	//
	function field_names($tableName){
		$d = $this->fields($tableName);
		foreach($d as $v){
			$ret[] = $v['name'];
		}
		return implode(',', $ret);
	}
	//
	// フィールドの存在確認 ... (戻り値) 存在しないfieldの数
	//
	function field_exists($tableName, $fields){
		$tblFields = $this->fields($tableName);
		$chkFields = explode(',', $fields);
		//
		$p = array();
		foreach($tblFields as $v) $p[] = $v['name'];
		$tblFieldsStr = '|'.implode('|', $p).'|';
		$ret = 0;
		foreach($chkFields as $chkF){
			$ret += (strpos($tblFieldsStr, '|'.$chkF.'|')) ? 0 : 1;
		}
		return $ret;
	}
	//
	// テーブル情報
	//
	function tables($mode=""){
		$tables = $this->query('select * from sqlite_master WHERE type="table"');
		while ($tbl = $tables->fetchArray(SQLITE3_ASSOC)){ $p[] = $tbl;}
		switch($mode){
			default: $ret = $p; break;
			case 'names_array':
				$ret = [];
				foreach($p as $v) $ret[] = $v['name'];
				break;
			case 'names_str':
				$ret = [];
				foreach($p as $v) $ret[] = $v['name'];
				break;
		}
		return $ret;
	}
	//
	//
	//
	function table_info($tableName, $dataName=""){
		$d = $this->tables();
		foreach($d as $v) $ret[ $v['tbl_name'] ] = $v;
		if( $dataName=="" ){
			return $ret[$tableName];
		}else{
			return $ret[$tableName][$dataName];
		}
	}
	//
	//
	//
	function indexes(){
		$indexes = $this->query('select * from sqlite_master WHERE type="index"');
		$idx = array();
		while($d = $indexes->fetchArray(SQLITE3_ASSOC)){
			$idx[] = $d['sql'];
		}
		return $idx;
	}
	function check($dbfile, $sqlfile, &$msg=""){ // データファイルの存在チェック。無ければ作成。
		if($dbfile=="")           { $msg = "db name is empty."; return false;} // ..................... db名の指定が無いならエラー
		if(!file_exists($sqlfile)){ $msg = "not found SQL file. '".$sqlfile."'."; return false;} // ... 作成用SQLファイルが無ければエラー
		//
		$d = explode('/', $dbfile);
		$fn = array_pop($d);
		$dir = implode('/', $d).'/';
		if(!is_dir($dir)){ // ------------------ フォルダが無ければ、フォルダとdbファイルを作る
			mkdir($dir, 0705, true);
			$this->_mkdb($dbfile, $sqlfile);
			$msg = basename($dbfile)." - create dir and dbfile.";
		}elseif(!file_exists($dbfile)){ // ----- フォルダはあるが、dbファイルが無ければ dbファイルを作る
			$msg = basename($dbfile)." - create dbfile.";
			$this->_mkdb($dbfile, $sqlfile);
		}else{
			$msg = basename($dbfile)." - exsist dbfile.";
		}
		return true;
	}
	// SQL定義ファイルを元に、dbファイルを作る 
	private function _mkdb($dbfile, $sqlfile){
		$this->open($dbfile);
		$txt = file_get_contents($sqlfile);
		if(strpos($txt, '#')!==false){
			$fp = fopen($sqlfile, 'r');
      $str = '';
			while(!feof($fp)){
				$line = fgets($fp);							// １行分を読み込む
				$d = explode('#', $line); $line = $d[0];	// 行の '#' より右は無視する
				$line = trim($line);						// 前後の半角スペースなどをカット
				if($line!="" and substr($line, 0, 1)!="#") $str .= $line;
			}
			fclose($fp);
			$dat = explode(";", $str);
			foreach($dat as $no=>$v){
				if($v!="") $this->exec($v);
			}
		}else{
			$this->exec($txt);
		}
		$this->close();
	}

}
?>