<?php /*
Plugin Name: PSKK
Version: 1.0.0
Requires PHP: 5.4 以降
Author: Parallel Soft
Author URI: https://parallel-soft.com/
Plugin URI: https://parallel-soft.com/pskk/
Description: 工事計画書管理 WordPress Plugin for 橋梁塗装(株)
*/
add_action('init', 'PSKK::init');
class PSKK {
  const SYS_VERSION = '1.0.0';
	public $sys;
  function __construct(){
    add_shortcode('pskk', [$this, 'show']);
    $usr = wp_get_current_user(); // ............ WordPressにログイン中のユーザー情報
    $this->sys['ver'] = self::SYS_VERSION;
    $this->sys['uid'] = $usr->user_login; // WordPressにログイン中のユーザーの「ログイン名」
    $this->sys['uml'] = $usr->user_email; // WordPressにログイン中のユーザーの「メールアドレス」
    $this->sys['mydir'] = plugin_dir_url(__DIR__).'pskk/'; // プラグインのフォルダ
    $config = json_decode(file_get_contents(__DIR__.'/config.json'), true);
    $this->sys['config'] = json_encode($config, JSON_UNESCAPED_UNICODE | JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_HEX_QUOT);
    foreach($config['users'] as $userKey=>$userValue){
      if( $this->sys['uid']==$userKey ){
        $err = false;
        $this->sys['user_name'] = $userValue['name'];
        $this->sys['user_grp']  = $userValue['group'];
        $this->sys['user_db']   = $config['group'][$userValue['group']]['db'];
        $this->sys['user_sub']  = $config['group'][$userValue['group']]['sub'];
        $this->sys['user_st']   = $config['group'][$userValue['group']]['ki_start'];
        list($base, $dmy) = explode('/wp-content/', __DIR__);
        $this->sys['db_fn']     = '/'.$this->sys['user_sub'].'/pskk_'.$this->sys['user_db'].'.db3';
        $this->sys['db_path']   = $base.'/wp-content/uploads/pskk'.$this->sys['db_fn'];
        $this->sys['db_exists'] = file_exists($this->sys['db_path']) ? "1" : "0";
        $this->sys['tmp_list']  = $this->cStr($config['templates']['koji_list']['wrp']);
        $this->sys['tmp_detail'] = $this->cStr($config['templates']['koji_detail']['wrp']);
        $this->sys['tmp_options'] = $this->cStr($config['templates']['options']['wrp']);
        break;
      }
    }
  }
  static function init(){ return new self(); }
	function show($op=[]){ // 初期表示
    $selector = $this->select_nendo($ki);
    $att = [];
    $att[] = 'data-sub="'.$this->sys['user_sub'].'"';
    $att[] = 'data-dbn="'.$this->sys['user_db'].'"';
    $att[] = 'data-st="'.$this->sys['user_st'].'"';
    $att[] = 'data-ex="'.$this->sys['db_exists'].'"';
    $att[] = 'data-fn="'.$this->sys['db_fn'].'"';
    $att[] = 'data-ki="'.$ki.'"';
    $att[] = 'data-ver="'.$this->sys['ver'].'"';
    $att[] = 'data-uid="'.$this->sys['uid'].'"';
    $att[] = 'data-uml="'.$this->sys['uml'].'"';
    
    $ret = ''
      .'<div id="pskk_contents" '.implode(' ', $att).'>'
        .'<div class="area message" style="text-align:center; padding:5em 0; background-color:#eee; font-size:1.5em;">工事管理システム 起動準備中 ...</div>'
        .'<div class="area list"    style="display:none;">'.$this->sys['tmp_list'].'</div>'
        .'<div class="area detail"  style="display:none;">'.$this->sys['tmp_detail'].'</div>'
        .'<div class="area sublist" style="display:none;"><span class="arrow_l"></span><span class="add_btn">&#43;</span><span class="items"></span></div>'
        .'<div class="area options" style="display:none;">'.$this->sys['tmp_options'].'</div>'
        .'<div class="area dialog"  style="display:none;"></div>'
        .'<div class="area select_nendo"  style="display:none;">'.$selector.'</div>'
        .'<div class="area config"  style="display:none;">'.$this->sys['config'].'</div>'
      .'</div>'
      .$this->link(['fn'=>'jquery/jquery-3.6.1.min.js'])
      .$this->link(['fn'=>'jquery-ui/jquery-ui.min.css'])
      .$this->link(['fn'=>'jquery-ui/jquery-ui.min.js'])
      .$this->link(['fn'=>'jquery.psPager.min.js'])
      .$this->link(['fn'=>'datepicker_settings.min.js'])
      .$this->link(['fn'=>'pskk_style.css'])
      .$this->link(['fn'=>'pskk_main.min.js']);
    return $ret;
	}
  function select_nendo(&$nowKI=0){ // 年度選択肢
    $ymd = $this->sys['user_st'];
    $fn  = $this->sys['db_path'];
    $viewaddki = 1;
    $st  = strtotime($ymd); // ...................... 創業開始の日時
    $now = strtotime(Date('Y-m-d')); // ............. 現在の日時
    $edY = intval(Date('Y')) + $viewaddki + 1; // ... 終了の「年」
    $ki = 1; // ........ ループ内で使用する「期」の数値（ループ内で加算）
    $items = [];
    do {
      $ed = strtotime('+1 year -1 day', $st); // ... 会計年度の最終日のタイムスタンプ
      $ymdST = date('Y-m-d', $st); // .............. 会計年度の開始日の「年月日」
      $ymdED = date('Y-m-d', $ed); // .............. 会計年度の最終日の「年月日」
      if( $nowKI > 0 ){ // ......................... 会計年度の「期」の指定があれば
        $sel = ( $nowKI==$ki ) ? 'selected' : ''; // ... ループ中の「期」を選択値とする
      }elseif( $now>=$st and $now<=$ed ){ // ....... それ以外で、くり返し期間に「現在の日時」が含まれるなら
        $sel = 'selected'; // その期を選択値とする
        $nowKI = $ki; // 選択地とした値を返す
      }else{ // .................................... それ以外
        $sel = '';
      }
      $txt = '第 '.$ki.' 期（'.$ymdST.' ～ '.$ymdED.'）';
      $att = [];
      $att[] = 'value="'.$ki.'"';
      $att[] = 'data-st="'.$ymdST.'"';
      $att[] = 'data-ed="'.$ymdED.'"';
      // if( $sel!="" ) $att[] = $sel;
      $items[] = '<option '.implode(' ', $att).'>'.$txt.'</options>';
      $y = intval(date('Y', strtotime($ymdED)));
      $st = strtotime('+1 year', $st );
      $ki++;
    }while( $y < $edY );
    $items = array_reverse($items);
    $att = [];
    $att[] = 'id="nendo"';
    // $att[] = 'date-add="'.$viewaddki.'"';
    $att[] = 'date-edy="'.$edY.'"';
    // $x = '<!-- '.$fn.' -->';
    return '<select '.implode(' ', $att).'>'.implode('', $items).'</select>';
  }
  function cStr($data){ // 配列であれば結合して文字列に
    return (is_array($data)) ? implode('', $data) : $data;
  }
  function link($e=[]){
    $ret = '';
    if( isset($e['fn']) ){
      if( substr($e['fn'], -4)==='.css' ){
        $ret = '<link href="'.$this->sys['mydir'].$e['fn'].'?ver='.$this->sys['ver'].'" type="text/css" rel="stylesheet">';
      }elseif( substr($e['fn'], -3)==='.js' ){
        $ret = '<script src="'.$this->sys['mydir'].$e['fn'].'?ver='.$this->sys['ver'].'" type="text/javascript"></script>';
      }
    }
    return $ret;
  }
}