/*!
	name: pskk_main.js
	Ver.: 3.0
	Date: 2022-09-30
*/
$(document).ready(function(e) {
  var me = $("#pskk_contents"),
    areaAll     = me.find('> div.area'),
    areaMessage = me.find('> div.area.message'),
    areaList    = me.find('> div.area.list'),
    areaDetail  = me.find('> div.area.detail'),
    areaOptions = me.find('> div.area.options'),
    areaDialog  = me.find('> div.area.dialog'),
    areaSubList = me.find('> div.area.sublist'),
    areaSelect  = me.find('> div.area.select_nendo'),
    config      = JSON.parse(me.find('> div.area.config').text()),
    psh_scr = "/wp-content/plugins/pskk/pskk_psh.php",
    psh = function (arJob, jobFunc, errFunc) {
      var uid = me.attr('data-uid'),
          uml = me.attr('data-uml'),
          sub = me.attr('data-sub'),
          dbn = me.attr('data-dbn'),
          job = $.extend({}, arJob, {uid:uid, uml:uml, sub:sub, dbn:dbn});
      $.ajax({
        data: JSON.stringify(job),
        url: psh_scr,
        error: function (e) {
          if ($.isFunction(errFunc)) {
            errFunc(e);
          } else {
            window.console.log({'psh-ERR': e});
          }
        },
        success: function (e, tp) { jobFunc(e); },
        type: 'POST', dataType: 'JSON', scriptCharset: 'UTF-8', contentType: 'application/JSON'
      });
    },
    psh_postKoji = function(okFunc, noFunc){ // 工事保存用
      var uid = me.attr('data-uid'),
          uml = me.attr('data-uml'),
          sub = me.attr('data-sub'),
          dbn = me.attr('data-dbn'),
          data = collectData(),
          job = {job:'postkoji', data:data, uid:uid, uml:uml, sub:sub, dbn:dbn};
      $.ajax({
        data: JSON.stringify(job), url: psh_scr,
        type: 'POST', dataType: 'JSON', scriptCharset: 'UTF-8', contentType: 'application/JSON',
        error: function (e) { window.console.log({'[psh_postKoji-ERR]': e});},
        success: function (e, tp) {
          console.log('[psh_postKoji-res]', e);
          if( e.res=='ok' ){ okFunc(e); }else{ noFunc(e); }
        }
      });
    },
    strToInt = function(e){ // ........ 文字列を数値化（不要な文字を削除して整数値に変換）
      var s = (''+e).replace(/[^0-9\-]/g, '');
      return (s==='' || s==='0') ? 0 : parseInt(s);
    },
    strToCur = function(e){ // ........ 文字列を数値化（不要な文字を削除して整数値に変換）し、通貨表示にする
      var s = (''+e).replace(/[^0-9\-]/g, '');
      return (s==='' || s==='0') ? '' : parseInt(s).toLocaleString();
    },
    recalcAll = function(){ // ........... 全体の再計算
      var kin1    = strToInt( areaDetail.find('input.fld[name="hdr_kin1"]').val() ), // ... 契約金額(税込)
          meisai  = areaDetail.find('input.fld[name^="m_"]'), // .... [予定-金額]、[実施-金額] 列
          nyukin  = areaDetail.find('input.fld[name^="nk_"]'), // ... [入金状況-金額] 列
          total_y = [0, 0, 0, 0], total_yg = 0,
          total_j = [0, 0, 0, 0], total_jg = 0,
          total_ng = 0;
      $.each(meisai, function(){ // 全フィールドを繰り返す
        var fld = $(this),
            name = fld.attr('name'),
            val = strToInt(fld.val()),
            m = name.match(/^m_(c[0-4])_([0-9]+)_([0-9]+)$/);
        //                      1:列no   2:種別    3:行
        if( m!==null ){
          var col = m[1],
              sb  = parseInt(m[2]);
          switch(col){
            case 'c2': total_y[sb] += val; total_yg += val; break;
            case 'c4': total_j[sb] += val; total_jg += val; break;
          }
        }
      })
      for(var i=0; i<=3; i++){
        setValue( areaDetail.find('input[name="total_y_'+i+'"]'), total_y[i], total_y[i]);
        setValue( areaDetail.find('input[name="total_j_'+i+'"]'), total_j[i], total_j[i]);
      }
      setValue( areaDetail.find('input[name="hdr_g1"]'), total_yg); // 予定合計
      setValue( areaDetail.find('input[name="hdr_g2"]'), total_jg); // 実施合計
      var p1 = kin1==0 ? '' : Math.round( total_yg / kin1 * 100 ); setValue( areaDetail.find('input[name="hdr_p1"]'), p1); // ... [総工事費率] = 予定合計 ÷ 契約金額(税込み)  （端数、四捨五入）
      var p2 = kin1==0 ? '' : Math.round( total_jg / kin1 * 100 ); setValue( areaDetail.find('input[name="hdr_p2"]'), p2); // ... [支払比率]   = 実施合計 ÷ 契約金額(税込み)  （端数、四捨五入）
      var p3 = kin1==0 ? '' : Math.round( (kin1 - total_jg) / kin1 * 100 ); setValue( areaDetail.find('input[name="hdr_p3"]'), p3); // ... [粗利率] = (契約金額(税込み) - 実施合計) ÷ 契約金額(税込み)
      $.each(nyukin, function(){
        total_ng += strToInt( $(this).val() );
      })
      setValue( areaDetail.find('input[name="hdr_g3"]'), total_ng); // 入金合計
    },
    recalcTaxIn = function(){ // ......... 税込み計算 ... [契約金額(税込)]
      var v0   = strToInt( areaDetail.find('.fld[name="hdr_kin0"]').val() ),
          taxp = strToInt( areaDetail.find('.fld[name="hdr_taxp"]').val() ),
          v1   = Math.floor( v0 * (100 + taxp) / 100 );
      setValue( areaDetail.find('input[name="hdr_kin1"]'), v1); // 値を代入し、初期値はセットしない（変更チェックの対象）
      console.log('[recalcTaxIn()]', v0, v1);
    },
    cYM = function(ymd){ // .............. 日付を「月日」に加工
      var v = new Date(ymd).getTime(),
          ret = '';
      if( isNaN(v)===false ){
        var tm= new Date(ymd);
        ret = ("0" + (tm.getMonth() + 1)).slice(-2) + '/' + ("0" + (tm.getDate())).slice(-2);
      }
      return ret;
    },
    isDateArea = function(ymd, st, ed){ // ......... ymd が st ～ ed の範囲内かどうか
      var d0 = new Date(ymd).getTime(),
          d1 = new Date(st).getTime(),
          d2 = new Date(ed).getTime();
      return (d1<=d0 && d0<=d2) ? true : false;
    },
    countChanged = function(){ // ........ 変更箇所をカウントして表示
      var n = areaDetail.find('.changed').length,
          obj = areaDetail.find('.detail_status > .status');
      if( n > 0 ){
        obj.text('変更箇所：'+n+' 件').attr('data-n', n);
      }else{
        obj.text('').attr('data-n', 0);
      }

    },
    collectData = function(){ // ......... 工事詳細のデータを収集する
      var id = strToInt( areaDetail.find('.hdr_id > .val').text() ),
          data = {id:id, hdr:{}, bdy:{}},
          log  = [];
      $.each(areaDetail.find('.changed.fld[name^="hdr_"]'), function(k, v){ // ... ヘッダ
        var my   = $(this),
            name = my.attr('name'),
            val  = getValue(my),
            m    = name.match(/^hdr_(.*)$/);
        log.push({name, val, m});
        if( m!==null ){
          if( m[1]=='end' ){ // status に収納するのは、現在 end のみ。
            var d = {end: val};
            data.hdr['status'] = JSON.stringify(d);
          }else{
            data.hdr[m[1]] = val;
          }
        }
      })
      $.each(areaDetail.find('.changed.fld[name^="m_"]'), function(k, v){ // ..... 明細
        // 明細の「予定」内で、変更された項目全てを、それぞれ繰り返すため、
        var my   = $(this),
            name = my.attr('name'),
            m = name.match(/^m_(c[0-2])_([0-9]+)_([0-9]+)$/);
        if( m!==null ){ // ............................. 細別  予定               | 実施
          var col = m[1], // .................. m[1] ... c0　 c1(項目名)　c2(金額) | c3(項目名)　c4(金額)
              ks  = parseInt( m[2] ,10), // ... m[2] ... 細別　0:材料費　1:労務費　2:現場管理費　3:一般管理費
              sb  = parseInt( m[3] ,10), // ... m[3] ... 細別内の行No（0 ～ ）
              key = 'y_' + ks + '_' + sb, // ........... 行ごとのキー
              ksn = function(e){
                ks_names = ['材料費', '労務費', '現場管理費', '一般管理費'];
                return ks_names[e];
              };
          if( data.bdy[key]===undefined ){ // ... 明細が未定義（その行で最初処理）の場合
            data.bdy[key] = {
              sb_name: my.parent('td').siblings('td.c2').children('input').val(), // 細別
              koumoku: my.parent('td').siblings('td.c3').children('input').val(), // 項目
              kin    : strToInt(my.parent('td').siblings('td.c4').children('input').val()), // 金額
              ks_name: ksn(ks),  // 工事種別名
              mainid : id,       // mainid
              date   : '',       // 予定 では空白
              ku     : 0,        // 0:予定
              jyun   : 0,        // (未使用)
              ks_id  : ks,       // 工事種別 No
              sb_id  : sb,       // 細別 No
              memo   : ''        // (未使用)
            }
          }
          switch(col){ // 行の「列」での分岐 ...（）
            case 'c0': data.bdy[key]['sb_name'] = getValue(my); break; // ............. [細別]
            case 'c1': data.bdy[key]['koumoku'] = getValue(my); break; // ............. [項目名]
            case 'c2': data.bdy[key]['kin']     = strToInt(getValue(my)); break; // ... [金額]
          }
        }
      })
      // 
      if( id===0 && hdr.taxp===undefined ){ // [新規登録]で、[消費税率]の更新がない場合は初期値を代入
        hdr.taxp = config.data.taxp;
      }
      return data;
    },
    hideFocus = function(){ // ........... focus 状態を消す
      var obj = areaAll.find('.focus');
      obj.removeClass('focus');
      areaDialog.hide();
      areaSubList.hide();
    },
    isChange = function(obj){ // ......... 指定フィールドの値が変更されたかのチェック
      var tag  = obj.prop('tagName'),
          type = obj.attr('type'),
          v0, v1, ret;
      switch(tag){
        case 'INPUT':
          switch(type){
            case 'checkbox':
              v0 = obj.attr('data-def'); if( v0===undefined ) v0 = '0';
              v1 = obj.prop('checked') ? "1" : "0";
              break;
            case 'tel': // 通貨など
              v0 = strToInt( obj.attr('data-def')===undefined ? '' : obj.attr('data-def') );
              v1 = strToInt( obj.val() );
              break;
            default:
              v0 = obj.attr('data-def'); if( v0===undefined ) v0 = '';
              v1 = obj.val();
              break;
          }
          break;
        case 'TEXTAREA':
          v0 = obj.attr('data-def'); if( v0===undefined ) v0 = '';
          v1 = obj.val();
          break;
      }
      var ret = v0===v1 ? false : true;
      // console.log({tag:tag, type:type, v0:v0, v1:v1, ret:ret}); // ************************
      if( ret ){
        obj.addClass('changed');
      }else{
        obj.removeClass('changed');
      }
      return ret;
    },
    getKojiID = function(){ // ........... 工事ID を得る（工事詳細の 工事No. から）
      return  strToInt(areaDetail.find('.detail_status .hdr_id .val').text());
    },
    getMeisaiNo = function(obj, na){ // ....... input[name] を分解して、種別no、細別no を得る
      var m = obj.attr('name').match(/^m_c([0-6])_([0-3])_([0-9]+)$/);
      if( m===null ){
        var ret = '';
      }else if( na=='ks'){
        var ret = m[2];
      }else if( na=='sb'){
        var ret = m[3];
      }else{
        var ret = '';
      }
      return ret;
    },
    getValue = function(obj){
      var tag  = obj.prop('tagName'),
          type = obj.attr('type'),
          val;
      switch(tag){
        case 'INPUT':
          switch(type){
            case 'checkbox': val = obj.is(':checked') ? "1" : "0"; break;
            case 'tel':      val = '' + strToInt(obj.val()); break;
            default:         val = obj.val(); break;
          }
          break;
        case 'SELECT': val = obj.find('option:selected').val(); break;
        default:       val = obj.val(); break;
      }
      return val;
    },
    setValue = function(obj, val, def){ // .... 値をセットする
      // val を obj に設定する
      // val は getValue() の結果であることが前提
      // def の定義がある場合は、初期値として data-def にその値をセットする（変更チェックの対象にしない）
      var tag  = obj.prop('tagName'), // ...... タグ名
          type = obj.attr('type'); // ......... type属性(INPUT)
      switch(tag){
        case 'INPUT':
          switch(type){
            case 'checkbox': obj.prop('checked', val=="1" ? true : false); break;
            case 'tel': // 通貨・数値
              if( obj.hasClass('cur') ){ obj.val( strToCur(val) ); } // 通貨
              else{ obj.val(val); }
              break;
            default: obj.val(val); break;
          }
          break;
        case 'TEXTAREA': obj.val(val); break;
      }
      if( def===undefined ){
        if( obj.attr('data-def')==val ){ obj.removeClass('changed'); }else{ obj.addClass('changed'); }
      }else{
        obj.attr('data-def', def);
        obj.removeClass('changed')
      }
    },
    focusShowSubList = function(obj, data){ // ... [実施金額] にフォーカス ... 実施データのサブリストを表示
      var fldKou = obj.parent('td').siblings('td.c5').children('input'),
          title = function(e){
            var ret = '';
            if( e.length > 0 ){
              ret = cYM(e[0]['date']) + ' ' + e[0]['koumoku'];
            }
            return ret;
          },
          total = function(e){
            if( e.length==0 ){
              return '';
            }else{
              var ret = 0;
              $.each(e, function(k, v){
                ret += v.kin;
              })
              return ret.toLocaleString();
            }
          },
          html_list = function(e){ // 取得した明細データから一覧の html を作成する
            var itm = '';
            if( e.length==0 ){ // 明細データがない場合
              itm += '<li><span>データがありません。</span></li>';
            }else{ // 明細データがある場合
              $.each(e, function(k,v){
                itm += '<li data-id="'+v.id+'" '+ // ............. id
                          'data-date="'+v.date+'" '+ // ......... date
                          'data-kin="'+v.kin+'" '+ // ........... kin
                          'data-koumoku="'+v.koumoku+'">'+ // ... koumoku
                  '<span>'+cYM(v.date)+' '+v.koumoku+'</span>'+
                  '<span>'+strToCur(v.kin)+'</span>'+
                  '</li>';
              })
            }
            return '<ul>'+itm+'</ul>';
          },
          detail_bottom = areaDetail.offset().top + areaDetail.outerHeight(true),
          dlg_x = obj.offset().left + obj.outerWidth(true) + 14,
          dlg_y = obj.offset().top;
      hideFocus();
      fldKou.val( title(data) ); // .... 自身の「項目名」を更新
      obj.val( total(data) ); // .... 自身の金額を再表示（html作成時に再計算したもの）
      obj.addClass('focus'); // ..... focus クラスを追加
      
      areaSubList.addClass('popup')
      areaSubList.find('.items').html( html_list(data) );
      areaSubList.show();
      var dlg_h = areaSubList.outerHeight();
      if( dlg_y + dlg_h > detail_bottom ){ dlg_y -= dlg_y + dlg_h - detail_bottom; }
      areaSubList.offset({left:dlg_x, top:dlg_y});
      areaSubList.find('.arrow_l').offset({top: obj.offset().top});
    },
    showList = function(e){ // ........... 工事一覧（初期表示・年度変更時）
      var ki = me.attr('data-ki'),
          st = me.attr('data-st');
      // console.log('[showList-start]', ki, st);
      psh({job:"list", ymd_start:st, nendo:ki}, function(e){
        // console.log('[list-res]', e);
        var rows = e.data,
            recs = rows.length,
            dbInfo = e.info,
            html = '',
            n = 0,
            list_cols = {
              id:    {cls: "num key"},
              name:  {cls: "txt"},
              kin1:  {cls: "cur"},
              tanto: {cls: "txt"},
              gst_name: {cls: "txt"},
              date1: {cls: "date"},
              arari: {cls: "cur"},
              p3:    {cls: "per"}
            },
            html_rows_none = '<tr class="norec"><td colspan=8>データがありません</td></tr>',
            total = {},
            list_table  = areaList.find('table#pskk_list'),
            list_tbody  = areaList.find('table#pskk_list tbody'),
            list_tfoot  = areaList.find('table#pskk_list tfoot'),
            list_status = areaList.find('#pskk_list_status'),
            state_user  = me.attr('data-uid')+' ( '+dbInfo['dbn']+' | '+dbInfo['lastupdate']+' )',
            state_ver   = 'PSKK Ver.'+me.attr('data-ver');
        if( recs>0 ){ // 明細がある場合
          $.each(rows, function(index, v){
            var status = (v.status==null) ? {} : JSON.parse(v.status), // status は、json化して保存されているので
                trCls = function(){
                  return ( status.end !== undefined && status.end==1 ) ? 'end' : ''; // ....... status の end は、工事が完了したかどうかのフラグ（0:未完了　1:完了）
                };
            html += '<tr data-id="'+v['id']+'" class="'+trCls()+'">';

            $.each(list_cols, function(k, col){
              switch(col.cls){
                case 'txt':
                  var v0 = v[k]==null ? '' : ''+v[k],
                      val = v0.replace('（','(').replace('）',')').replace('　', ' ');
                  break;
                case 'cur':
                  var v0 = v[k]==null ? 0 : strToInt(v[k]),
                      val = strToCur(v0);
                  if( total[k]===undefined ){ total[k] = v0; }else{ total[k] += v0;}
                  break;
                default:
                  var val = v[k]==null ? '' : ''+v[k];
                  break;
              }
              html += '<td class="'+col.cls+'">'+val+'</td>';
            })
            html += '</tr>';

          });
          // 総合計
          var t1 = ( total.kin1===undefined ) ? 0 : total.kin1,
              s1 = strToCur(t1), // ( t1===0 ) ? '' : t1.to LocaleString(),
              t2 = ( total.arari===undefined ) ? 0 : total.arari,
              s2 = strToCur(t2), // ( t2===0 ) ? '' :  t2.to LocaleString(),
              per = function(){
                return Math.floor(t2 / t1 * 100);
              };
          list_tfoot.find('td.jkin').text(s1);
          list_tfoot.find('td.arari').text(s2);
          list_tfoot.find('td.ararip').text(per());
        }else{
          html = html_rows_none;
          list_tfoot.find('td.jkin').text('');
          list_tfoot.find('td.arari').text('');
          list_tfoot.find('td.ararip').text('');

        }
        list_tbody.html(html); // ................................... 明細表示
        list_table.psPager({ perPage:false, rowsPerPage:25 }); // ... Pager の定義・表示
        list_status.find('span.c1').html(state_user); // ............ 一覧フッタ1
        list_status.find('span.c3').html(state_ver); // ............. 一覧フッタ3
        areaList.find("#nendo").val(ki); // ......................... 会計年度 選択肢を現在の日付が含まれる気に設定
        areaAll.hide();
        areaList.show();
      });
    },
    showListNyukin = function(e){ // ..... 入金明細の表示 ... 明細数が減った場合も想定して、data数ではなく入金明細全体を作り替える
      var rows = areaDetail.find('input.fld[name^=nk_]');
      $.each(rows, function(k, v){
        var n = function(){
              var m = $(v).attr('name').match(/^nk_([0-9]+)$/);
              return m===null ? false : m[1];
            },
            no = n();
            objYM  = areaDetail.find('input[name="nd_'+no+'"]'),
            objKin = $(v);
        if( e[no]===undefined ){
          objYM.val('');
          objKin.val('');
          objKin.removeAttr('data-id data-date data-koumoku data-kin data-def');
        }else{
          var ym = cYM(e[no]['date']),
              kin = e[no]['kin'];
          setValue(objYM, ym, ym);
          setValue(objKin, kin, kin);
          objKin.attr({
            'data-id'   : e[no]['id'],
            'data-date' : e[no]['date'],
            'data-koumoku' : e[no]['koumoku'],
            'data-kin' : e[no]['kin']
          });
        }
      })
    }
    showDetailDef = function(){ // ....... 工事詳細の全項目を初期化
      areaDetail.removeClass('add edit'); // ........................................ 工事詳細wrapの add edit を削除
      areaDetail.css({backgroundColor:"#FFF"});
      $.each(areaDetail.find('.fld[name]'), function(k, v){ // ...................... 全フィールドの値をクリア
        var my = $(this);
        setValue(my, '', ''); // ............................................. value, data-def を ''(空白) に設定する
        if( my.hasClass('nk_kin') ) my.removeAttr('data-id data-date'); // ... 入金金額のフィールドの場合、属性 data-id, data-date も削除
      })
      hideFocus(); // ............................................................... focus 時の状態をクリア
      areaDetail.find('.detail_status > .hdr_id > .val').text(''); // ............... id をクリア
      areaDetail.find('.detail_status > .status').text('').attr('data-n', ''); // ... ステータス（変更箇所）クリア
      $.each(config.data.sb, function(k, v){ // ..................................... [細別] の初期値を設定
        var ks = areaDetail.find('tr.'+k);
        $.each(v.rows, function(rk, rv){
          var n = rk + 1,
              obj = ks.eq(n).find('td.c2 > input');
          setValue(obj, rv.title, rv.title);
        })
      })
      setValue( areaDetail.find('input[name="hdr_taxp"]'), config.data.taxp, config.data.taxp ); // ... 消費税率の初期値を設定
      areaDetail.find('.changed').removeClass('changed'); // .......... 変更フラグをクリア
      areaDetail.find('.tabs > ul > li:nth-of-type(1)').click(); // ... 「計画書」タブを表示
    },
    showDetail = function(id=0){ // ...... 工事の値表示
      var ymd_st    = areaList.find('#nendo option:selected').attr('data-st'), // 工事一覧で表示中の会計期間の開始日
          ymd_ed    = areaList.find('#nendo option:selected').attr('data-ed'); // 工事一覧で表示中の会計期間の最終日
      showDetailDef(); // ................................................................. 初期状態にクリアする
      if( id===0 ){ // .................. [新規] id の指定がない場合は、新規登録
        areaDetail.addClass('add');
        areaDetail.css({backgroundColor:"#FFF0F0"});
        areaDetail.find('.tabs > ul > li:nth-of-type(2)').hide(); // ........................ タブ [実施明細一覧] を非表示
        areaDetail.find('button#pskk_delkoji').hide(); // ................................... [工事削除] ボタンの非表示
        areaDetail.find('input[name="hdr_end"]').prop('disabled', true); // ................. [工事状況] の無効化
        areaDetail.find('input[name="hdr_end"]').next('span').css({color:"#ccc"}); // ....... （入力完了）
        areaDetail.find('input[name="hdr_date2"]').prop({'min':ymd_st, 'max':ymd_ed}); // ... [工期(至)] は一覧表示中の期間内に限定する
        areaAll.hide();
        areaDetail.show();
      }else{ // ......................... [変更]
        areaDetail.addClass('edit');
        psh({job:"detail", id:id}, function(e){
          areaDetail.find('.detail_status .hdr_id > .val').text(id);
          areaDetail.find('.tabs > ul > li:nth-of-type(2)').show(); // ..................... タブ [実施明細一覧] を表示
          areaDetail.find('button#pskk_delkoji').show(); // ................................ [工事削除] ボタンの表示
          areaDetail.find('input[name="hdr_end"]').prop('disabled', false); // ............. [工事状況] の有効化
          areaDetail.find('input[name="hdr_end"]').next('span').css({color:"unset"}); // ... （入力完了）
          console.log('[showDetail-ret]', e); // ************
          $.each(e.res, function(k, v){
            switch(k){
              case 'hdr': // ......................... ヘッダ（hdr）
                $.each(v, function(hKey, hVal){
                  if( hKey=='status' ){
                    setValue( areaDetail.find('[name="hdr_end"]'), hVal.end, hVal.end);
                  }else{
                    setValue( areaDetail.find('[name="hdr_'+hKey+'"]'), hVal, hVal);
                  }
                })
                break;
              case 'nyukin': // ...................... 入金
                showListNyukin(v);
                break;
              default: // ............................ その他 ... 明細（y_, j_）
                var m = k.match(/^(y|j)_([0-9]+)_([0-9]+)$/);
                if( m!==null ){
                  if( m[1]==='y' ){ // ......... [予定] 明細データは 0 のみ
                    var fld0 = areaDetail.find('input[name="m_c0_'+m[2]+'_'+m[3]+'"]'),
                        fld1 = areaDetail.find('input[name="m_c1_'+m[2]+'_'+m[3]+'"]'),
                        fld2 = areaDetail.find('input[name="m_c2_'+m[2]+'_'+m[3]+'"]'),
                        kin  = v[0]['kin'];
                    setValue(fld0, v[0]['sb_name'], v[0]['sb_name']);
                    setValue(fld1, v[0]['koumoku'], v[0]['koumoku']);
                    setValue(fld2, kin, kin);
                  }else if( m[1]==='j' ){ // ... [実施] 複数明細あり
                    var fld1 = areaDetail.find('input[name="m_c3_'+m[2]+'_'+m[3]+'"]'), // [項目名]
                        fld2 = areaDetail.find('input[name="m_c4_'+m[2]+'_'+m[3]+'"]'), // [金額]
                        kou  = cYM(v[0]['date'])+' '+v[0]['koumoku'],
                        kei  = function(){
                          var ret = 0;
                          $.each(v, function(k2, v2){ ret += v2['kin']; })
                          return ret;
                        };
                    setValue(fld1, kou, kou);
                    setValue(fld2, kei(), kei());
                  }
                }
                break;
            }
          })
          recalcAll();
          areaDetail.find('.changed').removeClass('changed');
          areaAll.hide();
          areaDetail.show();
        })
      }
    },
    confirmSubForm = function(){ // ...... サブフォーム（実施明細、入金明細）の入力確認
      var fldDate = areaDialog.find('input.subfld[name=date]'),
          fldKou  = areaDialog.find('input.subfld[name=koumoku]'),
          fldKin  = areaDialog.find('input.subfld[name=kin]'),
          objCaution = areaDialog.find('div.caution');
      if( getValue(fldDate)=='' || getValue(fldKin)==0 ){ // [日付]、[金額] が空欄の場合
        objCaution.text('日付 または 金額 が未入力です。').show();
        return false;
      }else{
        objCaution.text('').hide();
        return true;
      }
    }
    init = function(){ // ................ 初期加工
      // 工事一覧
      var listTitleKi = areaList.find('span.now_ki'),
          listSelectKi = areaList.find("#pskk_select_ki span"),
          listAddButton = areaList.find("#add_koji"),
          ki = me.attr('data-ki');
      listAddButton.button(); // ..................................................... [新規工事]ボタン の形状定義
      listTitleKi.text(ki); // ....................... タイトルの [期] を表示
      listSelectKi.html( areaSelect.html() ); // ... [期] の選択肢を表示 ※選択肢は初期のみで表示
      // 工事詳細
      areaDetail.html( config.tmp_detail );
      var btnToList = areaDetail.find('.toolbar .tolist'),
          btnPost   = areaDetail.find('.toolbar .post'),
          btnDelete = areaDetail.find('#pskk_delkoji');
      btnToList.button(); // ... [一覧へ戻る] ボタンの UI 表示
      btnPost.button(); // ..... [保存] ボタンの UI 表示
      btnDelete.button(); // ... [工事削除] ボタンの UI 表示
      //
      showList();
    };
  // init
  init();
  // events -----------
  areaList // ---------------------------------------------------- 工事一覧 ----------
    .on('click', '#add_koji', function(){ // ..................... [新規登録] クリック
      showDetail();
    })
    .on('click', '#pskk_options', function(){ // ................. [設定] クリック
      areaOptions.html( config.tmp_options )
        .dialog({
          width:400, modal:true, title:"設定", autoOpen:true, resizable:false,
          position:{my:"right top", at:"right bottom", of:btnOption },
          open: function(){ // 開いた時 ... テーブル etc の情報を表示
            psh({job:"getoption"}, function(e){
              var opData = e.res;
              areaOptions.find('[name^="etc_"]').each(function() { // フォームのフィールドを繰り返す
                var m = $(this).attr('name').match(/^etc_(.*)$/),
                    key = m[1];
                if( opData[key]!==undefined ) $(this).val(opData[key]);
              });
            })
          },
          buttons:{
            '保存': function(){
              var data = {};
              areaOptions.find('[name^="etc_"]').each(function(){
                var m = $(this).attr('name').match(/^etc_(.*)$/);
                data[m[1]] = $(this).val();
              });
              psh({job:"postoption", data: data}, function(e){
                areaOptions.dialog("close");
              });
            },
            'キャンセル': function(){ areaOptions.dialog("close");}
          }
        });
    })
    .on('click', '#pskk_list tr[data-id]', function(){ // ........ [工事の選択] ... id を指定して工事詳細表示
      var id = $(this).attr('data-id');
      showDetail(id);
    })
    .on('change', '#nendo', function(){ // ....................... [会計期間] を変更した
      var ki = $(this).val(),
          listTitleKi = areaList.find('span.now_ki');
      me.attr('data-ki', ki);
      listTitleKi.text(ki);
      showList();
    });
  areaDetail // -------------------------------------------------- 工事詳細 -------------
    .on('click', '.toolbar .tolist', function(){ // .............. [一覧へ戻る] クリック
      var n = areaDetail.find('.detail_status > .status').attr('data-n');
      if( n > 0 ){
        var html = '<div class="ui-widget">'+
              '<div class="ui-icon ui-icon-alert" style="float: left; margin: 0 7px 20px 0;"></div>'+
              '<p>このまま工事一覧に戻ると、変更内容は無効になります。<br>工事一覧に戻りますか？</p>'+
              '</div>';
        areaDialog.html(html).dialog({ title:'変更箇所があります', dialogClass:'caution',
            width:470, modal:true, autoOpen:true, resizable:false,
            position: {my:"right top", at:"right bottom", of:$(this) },
            buttons: {
              '変更を破棄して工事一覧に戻る': function(){
                areaDialog.dialog("destroy");
                areaAll.hide();
                areaList.show();
              },
              '入力に戻る': function(){
                areaDialog.dialog("destroy");
              }
            }
          });
      }else{
        areaAll.hide();
        areaList.show();
      }
    })
    .on('click', '.toolbar .post', function(){ // ................ [保存] クリック
      var hdr_name = areaDetail.find('input.fld[name=hdr_name]'), // ..... 工事名
          hdr_date1 = areaDetail.find('input.fld[name=hdr_date1]'), // ... 工期(自)
          hdr_date2 = areaDetail.find('input.fld[name=hdr_date2]'), // ... 工期(至)
          count_cng = strToInt( areaDetail.find('.detail_status > .status').attr('data-n') ),
          ymd_st = areaList.find('#nendo option:selected').attr('data-st'), // 工事一覧で表示中の会計期間の開始日
          ymd_ed = areaList.find('#nendo option:selected').attr('data-ed'); // 工事一覧で表示中の会計期間の最終日
      //

      if( hdr_name.val()=="" || hdr_date2.val()=="" ){ // ................... 工事名・工期(至) が空欄の場合
        var html = '<p style="color:#C00; text-align:center;">工事を登録するには、少なくとも、<br><strong>工事名</strong>と<strong>工期(至)</strong>は必要です。</p>';
        areaDialog.html(html).dialog({ title:'保存できません', dialogClass:'caution',
            width:400, modal:true, autoOpen:true, resizable:false, position:{my:"right top", at:"right bottom", of:$(this) },
            buttons:{ '入力に戻る': function(){
              areaDialog.dialog("destroy");
              if( hdr_date2.val()=="" ) hdr_date2.focus();
              if( hdr_name.val()=="" ) hdr_name.focus();
            }}
          });
        return false;
      }else if( count_cng===0 ){ // ......................................... 変更箇所がない場合
        var html = '変更箇所がありませんので、保存の必要がありません。';
        areaDialog.html(html).dialog({ title:'保存できません', dialogClass:'caution',
            width:450, modal:true, autoOpen:true, resizable:false,
            position:{my:"right top", at:"right bottom", of:$(this) },
            buttons:{ '入力に戻る': function(){ areaDialog.dialog("destroy"); } }
          });
      }else if( isDateArea(hdr_date2.val(), ymd_st, ymd_ed)===false ){ // ... 工期(至)が、現在の会計期間内ではない場合
        var html = ''+
          '<div style="color:#C00; background-color:#FEE; line-height:3em; text-align:center;">'+
          '<strong>工期(至)</strong> の <strong>' + hdr_date2.val() + '</strong> は、現在の会計期間外です。</div>'+
          '<p>このまま保存できますが、現在の会計期間の一覧には表示されません。<br>'+
          '現在表示中の会計期間：' + ymd_st + ' ～ ' + ymd_ed+ '<br>'+
          '</p>';
        areaDialog.html(html).dialog({ title:'保存', dialogClass:'caution',
            width:600, modal:true, autoOpen:true, resizable:false,
            position:{my:"right top", at:"right bottom", of:$(this) },
            buttons:{
              '強制的に保存する': function(){
                psh_postKoji(
                  function(e){ showList(); areaDialog.dialog("destroy"); },
                  function(e){ areaDialog.html(e.res); }
                )
              },
              '入力に戻る': function(){ areaDialog.dialog("destroy"); }
            }
          });
      }else{ // ............................................................. 保存実行
        var html  = '工事内容を保存します。よろしいですか？';
        areaDialog.html(html).dialog({ title:"保存",
            width:400, modal:true, autoOpen:true, resizable:false,
            position:{my:"right top", at:"right bottom", of:$(this) },
            buttons:{
              '保存': function(){
                psh_postKoji(
                  function(e){ showList(); areaDialog.dialog("destroy"); },
                  function(e){ areaDialog.html(e.res); }
                )
              },
              '入力に戻る': function(){ areaDialog.dialog("destroy");}
            }
          });
      }
    })
    .on('click', '#pskk_delkoji', function(){ // ................. [工事削除] ボタン
      areaDialog.html('この工事を削除します。よろしいですか？')
        .dialog({ title: '工事削除',
          width:400, modal:true, autoOpen:true, resizable:false,
          position: {my:"right top", at:"right bottom", of:$(this)},
          buttons: [
            {
              text: "削除実行",
              click: function(){
                var id = strToInt( areaDetail.find('.hdr_id > .val').text() );
                psh({job:"delkoji", id:id}, function(e){
                  console.log('[delkoji-res]', e);
                  if( e.res=='ok' ){
                    showList();
                    areaDialog.dialog("destroy");
                  }else{
                    areaDialog.html(e.res);
                  }
                })
              }
            },
            {
              text: "キャンセル",
              click: function(){ areaDialog.dialog('destroy');}
            }
          ]
        });
    })
    .on('click', '.tabs > ul > li', function(){ // ............... [タブ] クリック
      var my = $(this),
          id = my.attr('data-tab'),
          obj = areaDetail.find('article[data-tab="'+id+'"]');
      hideFocus();
      my.siblings().removeClass('act');
      my.addClass('act');
      my.parent().siblings('article').hide();
      obj.show();
      // console.log(id);
      if( id==2 ){
        psh({job:"getmeisai", koji_id: getKojiID(), ku:1 }, function(e){
          // console.log('[---]', e); // ***********
          var thead = '<thead><tr><td>日付</td><td>項目</td><td>金額</td><td>種別</td><td>細別</td></tr></thead>',
              tbody = function(){
                var ret = '<tbody>';
                $.each(e.res, function(k, v){
                  ret += '<tr data-id="'+v.id+'">'+
                    '<td class="date">'+v.date+'</td>'+
                    '<td class="text">'+v.koumoku+'</td>'+
                    '<td class="cur">'+v.kin.toLocaleString()+'</td>'+
                    '<td class="text" data-no='+v.ks_id+'>'+config.data.ks[v.ks_id]+'</td>'+
                    '<td class="text" data-no='+v.sb_id+'>'+areaDetail.find('input.fld[name="m_c0_'+v.ks_id+'_'+v.sb_id+'"]').val()+'</td></tr>';
                })
                return ret+'</tbody>';
              },
              html = '<div><table>'+thead+tbody()+'</table></div>';
          obj.find('#ku1_list').html(html) // { perPage:false, rowsPerPage:25 }
          obj.find('#ku1_list > div > table').psPager();
        })
      }
    })
    .on('change', 'input.fld[name="hdr_taxp"]', function(){ // ... [消費税率] を変更した
      recalcTaxIn();
    })
    .on('keyup', '.fld.edit', function(e){ // .................... [fld] keyup ... [Enter]の時、項目移動
      var c = e.which ? e.which : e.keyCode;
      switch(c){
        case 13: // [Enter] で次の項目へ移動
          var my = $(this),
              tn = my.prop('tagName'),
              idx = my.attr('tabindex'),
              nxt = null;
          if( idx===undefined && my.parent().hasClass('c2') ){ // .................. tabindex 属性がなく、親の class に c2 がある（細別の列）場合
            nxt = my.parent().siblings('td.c3').children('input'); // ....... その右側のフィールド（項目名）が移動先
          }else if( tn != "TEXTAREA" ){ // ......................................... タグ名が TEXTAREA でない場合（TEXTAREAでは Enter で移動しない）
            nxt = areaDetail.find('[tabindex='+(strToInt(idx)+1)+']'); // ... 次の tabindex が移動先
            if( nxt.length==0 ) nxt = areaDetail.find('[tabindex=1]'); // .... 移動先が無い場合は、先頭が移動先
          }
          if( nxt.length>0 ) nxt.focus();
          break;
      }
    })
    .on('focus', '.fld', function(){ // .......................... [.fld] に focus
      var my = $(this),
          myName = my.attr('name'),
          kid = strToInt(areaDetail.find('.hdr_id > .val').text());
      hideFocus();
      if( my.hasClass('edit') ){ // ................... [.fld.edit] 入力可能なフィールド
        if( my.hasClass('cur') ){ // ........... [.fld.edit.cur] 通貨
          my.val( strToInt(my.val()) ); // ..... 数値のみに変換
        }
        if( my.hasClass('list') ){ // .......... [.fld.edit.list] 入力値の選択肢を表示する準備
          my.autocomplete({ // ................. autocomplete（選択肢）を定義
            minLength: 0,
            source: function(req, res){
              var uid = me.attr('data-uid'),
                  uml = me.attr('data-uml'),
                  sub = me.attr('data-sub'),
                  dbn = me.attr('data-dbn'),
                  job = {job:"selector", key:myName, inp:req.term, uid:uid, uml:uml, sub:sub, dbn:dbn};
              $.ajax({
                data: JSON.stringify(job),
                url: psh_scr,
                type: "POST",
                cache: false,
                dataType: "json",
                success: function(e){ res(e.res);},
                error: function(xhr, ts, err){ console.log(err.message);}
              });
            }
          })
        }
        my.select(); // ........................ 値を選択状態にする
      }else if( my.hasClass('list2') && kid>0 ){ // ... [.fld.list2] サブリストを表示
        psh({job:"getmeisai", koji_id:kid, fld_name:my.attr('name')}, function(e){ // ... そのサブ明細を表示
          focusShowSubList(my, e.res);
        })
      }else if( my.hasClass('nk_kin') ){ // ........... [.fld.nk_kin] 入金 - 金額
        var mid = my.attr('data-id')===undefined ? 0 : my.attr('data-id');
        my.addClass('focus');
        if( mid===0 ){ // ............................. 入金の空欄箇所をクリックした時 ..... 登録
          areaDialog // ..................................................... ダイアログ
            .html(config.templates.koji_subform.wrp.join(''))
            .dialog({
              width:300, modal:true, title:"入金（追加登録）", autoOpen:true, resizable:false,
              position:{my:"right top", at:"right bottom", of:my },
              open: function(){ // .......................................... 開いた時
                areaDialog.find('div.del').hide();
              },
              close: function(){ // ......................................... [✕] で閉じたとき
                areaDialog.dialog("destroy");
              },
              buttons:{
                '保存': function(){ // ...................................... [保存] ボタン
                  if( confirmSubForm() ){
                    var data = {
                        mainid  : getKojiID(),
                        date    : getValue( areaDialog.find('input.subfld[name=date]') ),
                        ku      : 2, // 2:入金
                        koumoku : getValue( areaDialog.find('input.subfld[name=koumoku]') ),
                        kin     : strToInt( areaDialog.find('input.subfld[name=kin]').val() )
                      };
                    psh({job:"postmeisai", data:data}, function(e){
                      console.log('[nyukin-add-res]', e);
                      showListNyukin(e.data);
                      recalcAll();
                      areaDialog.dialog("destroy");
                    });
                  }
                },
                '閉じる': function(){ // ..................................... [閉じる] ボタンクリック
                  areaDialog.dialog("destroy");
                }
              }
            });
        }else{ // ..................................... 入金情報のある行をクリックした時 ... 変更・削除
          areaDialog // ..................................................... ダイアログ
            .html(config.templates.koji_subform.wrp.join(''))
            .dialog({
              width:300, modal:true, title:"入金（変更）", autoOpen:true, resizable:false,
              position:{my:"right top", at:"right bottom", of:my },
              open: function(){ // .......................................... 開いた時
                areaDialog.find('div.stat span.key').text( mid );
                areaDialog.find('input.subfld[name=date]').val( my.attr('data-date') );
                areaDialog.find('input.subfld[name=koumoku]').val( my.attr('data-koumoku') );
                areaDialog.find('input.subfld[name=kin]').val( strToCur(my.attr('data-kin')) );
              },
              close: function(){ // ......................................... [✕] で閉じたとき
                areaDialog.dialog("destroy");
              },
              buttons:{
                '保存': function(){ // ...................................... [保存] ボタン
                  var del = getValue( areaDialog.find('.del > label > input[name="del"]')),
                      data = {
                        id      : mid,
                        mainid  : getKojiID(),
                        date    : getValue( areaDialog.find('input.subfld[name=date]') ),
                        ku      : 2, // 2:入金
                        koumoku : getValue( areaDialog.find('input.subfld[name=koumoku]') ),
                        kin     : strToInt( areaDialog.find('input.subfld[name=kin]').val() )
                      };
                  psh({job:"postmeisai", data:data, del:del}, function(e){
                    console.log('[nyukin-update-res]', e);
                    showListNyukin(e.data);
                    recalcAll();
                    areaDialog.dialog("destroy");
                  });
                },
                '閉じる': function(){ // ..................................... [閉じる] ボタンクリック
                  areaDialog.dialog("destroy");
                }
              }
            });
          
        }
      }
    })
    .on('blur', '.fld', function(){  // ............... [fld] から抜ける ... 再計算
      var my = $(this);
      if( my.hasClass('edit') ){ // ........ 編集可能なフィールド
        if( my.hasClass('cur') ){ // ....... 通貨 のフィールド ... 自身の通貨表示、全体の再計算、契約金額(税込)計算
          if( my.attr('name')=='hdr_kin0' ){ // ........ [契約金額(税抜)] の場合
            recalcTaxIn(); // .......................... [契約金額(税込)] を再計算
          }
          my.val( strToCur(my.val()) ); // ............. 自身の値を通貨表示（３桁カンマ区切り）にする
          recalcAll(); // .............................. 全体の再計算を行う
        }
        if( my.hasClass('list') ){ // ...... list のあるフィールド
          my.autocomplete("destroy"); // ... autocomplete() を破棄
        }
        isChange(my); // ..... この項目自身の変更チェック（自身の項目はキー入力されているので、setValue() は行なわない）
        countChanged(); // ... 全体の変更箇所をカウントする
      }
    })
  areaSubList // -------------------------------------- 実施サブリスト
    .on('click', '.add_btn', function(e){ // ..................... [＋] クリック ............... 実施明細の「登録」
      var obj = areaDetail.find('.focus');
      areaDialog
        .html(config.templates.koji_subform.wrp.join(''))
        .dialog({
          width:300, modal:true, title:"実施明細 追加登録", autoOpen:true, resizable:false,
          position:{my:"right top", at:"right bottom", of:obj},
          open: function(){ // 開いた時
            areaDialog.find('.kid').text( getKojiID() ); // ................. 工事id
            areaDialog.find('.ks_id').text( getMeisaiNo(obj, 'ks') ); // .... 種別No
            areaDialog.find('.sb_id').text( getMeisaiNo(obj, 'sb') ); // .... 細別No
            areaDialog.find('div.del').hide();
          },
          buttons:{
            '保存': function(){
              var data = {
                    mainid  : strToInt( areaDialog.find('.stat .kid').text() ),
                    date    : getValue( areaDialog.find('input.subfld[name=date]') ),
                    ku      : 1, // 1:実施
                    jyun    : 0, // (未使用)
                    ks_id   : strToInt( areaDialog.find('.stat .ks_id').text() ),
                    ks_name : '', // (実施明細では未使用)
                    sb_id   : strToInt( areaDialog.find('.stat .sb_id').text() ),
                    sb_name : '', // (実施明細では未使用)
                    koumoku : getValue( areaDialog.find('input.subfld[name=koumoku]') ),
                    kin     : strToInt( areaDialog.find('input.subfld[name=kin]').val() ),
                    memo    : ''
                  };
              console.log('[postmeisai-add-before]', data);
              psh({job:"postmeisai", data:data}, function(e){
                obj.focus();
                areaDialog.dialog("destroy");
              });
            },
            'キャンセル': function(){ areaDialog.dialog("destroy");}
          }
        });

    })
    .on('click', '.items > ul > li[data-id]', function(e){ // .... [サブリスト]の明細クリック ... ダイアログを開く
      var my = $(this),
          obj = areaDetail.find('.focus');
      areaSubList.find('li.active').removeClass('active');
      my.addClass('active');
      areaDialog // ..................................................... ダイアログ
        .html(config.templates.koji_subform.wrp.join(''))
        .dialog({
          width:300, modal:true, title:"実施明細（変更）", autoOpen:true, resizable:false,
          position:{my:"right top", at:"right bottom", of:obj},
          open: function(){ // .......................................... 開いた時
            areaDialog.find('.key').text( strToInt( my.attr('data-id') ) ); // ................... id      (明細自身のid)
            areaDialog.find('.kid').text( strToInt( getKojiID() )); // ........................... mainid  (工事id)
            areaDialog.find('.ks_id').text( getMeisaiNo(obj, 'ks') ); // ......................... 種別no
            areaDialog.find('.sb_id').text( getMeisaiNo(obj, 'sb') ); // ......................... 細別no
            areaDialog.find('input.subfld[name=date]').val( my.attr('data-date') ); // ........... 日付
            areaDialog.find('input.subfld[name=koumoku]').val( my.attr('data-koumoku') ); // ..... 項目
            areaDialog.find('input.subfld[name=kin]').val( strToCur(my.attr('data-kin')) ); // ... 金額
          },
          close: function(){
            areaSubList.find('li.active').removeClass('active');
          },
          buttons:{
            '更新': function(){ // .............................................. 「更新」ボタン
              var data = {
                    id      : strToInt( areaDialog.find('.stat .key').text() ),
                    mainid  : strToInt( areaDialog.find('.stat .kid').text() ),
                    ku      : 1, // 1:実施
                    ks_id   : strToInt( areaDialog.find('.stat .ks_id').text() ),
                    sb_id   : strToInt( areaDialog.find('.stat .sb_id').text() ),
                    date    : getValue( areaDialog.find('input.subfld[name=date]') ),
                    koumoku : getValue( areaDialog.find('input.subfld[name=koumoku]') ),
                    kin     : strToInt( areaDialog.find('input.subfld[name=kin]').val() )
                  },
                  del = getValue( areaDialog.find('.del > label > input[name="del"]'));
              if( del==1 ){
                if( confirm('この明細を削除します。よろしいですか？') ){
                  psh({job:"postmeisai", data:data, del:del}, function(e){
                    console.log('[postmeisai-del-res]', e);
                    obj.focus();
                    areaDialog.dialog("destroy"); 
                  });
                }else{
                  areaDialog.dialog("destroy"); 
                }
              }else{
                psh({job:"postmeisai", data:data}, function(e){
                  obj.focus();
                  areaDialog.dialog("destroy"); 
                });
              }
            },
            '閉じる': function(){
              areaSubList.find('li.active').removeClass('active');
              areaDialog.dialog("destroy");
            }
          }
        });
    })
  areaDialog // 
    .on('keyup', 'input.subfld', function(e){ // ...... サブリスト内の subfld で [Enter] ... 次の項目へ移動
      var my = $(this),
          c = e.which ? e.which : e.keyCode;
      switch(c){
        case 13:
          var idx = strToInt(my.attr('tabindex')),
              nxt = areaDialog.find('input.subfld[tabindex='+(idx+1)+']');
          if( nxt.length > 0 ){
            nxt.focus();
          }else{
            areaDialog.find('input.subfld[tabindex=1]').focus();
          }
          break;
      }
    })
    .on('focus', 'input.subfld', function(e){ // ...... サブリスト内の subfld に focus ... 選択状態にする。通貨ではさらに値を数値のみにする。
      var my = $(this);
      if( my.hasClass('cur') ){
        my.val( strToInt(my.val()) ); // ... 数値のみに変換
      }
      my.select();
    })
    .on('blur', '.subfld', function(){ // ............. サブリスト内の subfld から抜ける時　... 通貨表示にする
      var my = $(this);
      if( my.hasClass('cur') ){
        my.val( strToCur(my.val()) );
      }
    })
});
