<?php
date_default_timezone_set('Asia/Tokyo');
mb_internal_encoding("utf-8");
$post   = json_decode( file_get_contents('php://input') , true);
$config = json_decode( file_get_contents(__DIR__.'/config.json'), true);
include(__DIR__."/psc_mysqlite3.php");
$db  = new mysqlite3();
if( isset($post['sub']) and $post['sub']!="" and isset($post['dbn']) and $post['dbn']!="" ){
  list($base, $dmy) = explode('/wp-content/', __DIR__);
  $path = $base.'/wp-content/uploads/pskk/'.$post['sub'].'/pskk_'.$post['dbn'].'.db3';
  $ex   = file_exists($path) ? true : false;
  if( $ex===false ) $db->check($path, 'tables.sql', $msg); // dbがない場合、tables.sql を基に dbファイルを作成
  $post['db_path'] = $path;
}
switch($post['job']){
  default:           echo json_encode(_err($post)); break;
  case 'chkuser':    echo json_encode(chkuser($post)); break;
  case 'list'   :    echo json_encode(koji_list($post)); break;
  case 'getoption':  echo json_encode(getOptions($post)); break;
  case 'getmeisai':  echo json_encode(getMeisai($post)); break;
  case 'postoption': echo json_encode(postOptions($post)); break;
  case 'postkoji':   echo json_encode(postKoji($post)); break;
  case 'postmeisai': echo json_encode(postMeisai($post)); break;
  case 'delkoji':    echo json_encode(delKoji($post)); break;
  case 'selector':   echo json_encode(selector($post)); break;
  case 'detail':     echo json_encode(detail($post)); break;
}
exit(0);

function chkuser($post){ // ユーザーチェック ... 初期の会計年度選択肢作成
  global $db, $config;
  if( $post['uid']=="" ){
    $res = false;
    $err = '<h2>工事管理システム for 橋梁塗装(株)</h2><p>利用可能なユーザーでログインしてください。</p>';
  }else{
    // $config = json_decode(file_get_contents(__DIR__.'/config.json'), true);
    $res = false;
    $err = '<h2>工事管理システム for 橋梁塗装(株)</h2><p>ログイン中の「'.$post['uid'].'」は、このシステムを利用できません。<br>利用を許可されているユーザーで再ログインしてください。</p>';
    foreach($config['users'] as $k=>$v){
      if( $post['uid']==$k ){
        $err = false;
        // list($base, $dmy) = explode('/wp-content/', __DIR__);
        // $dbn  = $config['group'][$v['group']]['db'];
        // $sub  = $config['group'][$v['group']]['sub'];
        // $path = $base.'/wp-content/uploads/pskk/'.$sub.'/pskk_'.$dbn.'.db3';
        // $ex   = file_exists($path) ? true : false;
        // if( $ex===false ) $db->check($path, 'tables.sql', $msg); // dbがない場合、tables.sql を基に dbファイルを作成
        // $post['db_name'] = $dbn;   $post['dbn'] = $dbn;
        // $post['db_sub']  = $sub;   $post['sub'] = $sub;
        // $post['db_path'] = $path;
        // $post['db_ext']  = $ex;
        $res = [
          'id'   => $k,
          'ml'   => $v['mail'],
          'na'   => $v['name'],
          'st'   => $config['group'][$v['group']]['ki_start'],
          'dbn'  => $dbn,
          'sub'  => $sub,
          'data' => $config['data'],
          'tmp_list'     => cStr($config['templates']['koji_list']['wrp']),
          'tmp_detail'   => cStr($config['templates']['koji_detail']['wrp']),
          'tmp_options'  => cStr($config['templates']['options']['wrp']),
          // 'select_nendo' => select_nendo($config['group'][$v['group']], $ki),
          // 'ki' => $ki  // select_nendo() 実行結果の $ki を使用するので、必ずその後
        ];
        break;
      }
    }
  }
  return [
    'debug'=>['post'=>$post, 'config'=>$config],
    'err'=>$err,
    'res'=>$res
  ];
}
function select_nendo($grp, &$nowKI=0){ // 年度選択肢の初期表示 ... 
  // chkuser から呼び出される。この時点では、ユーザーは決定しているが、システムに反映していないので、システムからの db sub の指示は来ていない。
  global $db, $post;
  $ymd = $grp['ki_start'];
  $fn  = $post['db_path']; // "../../uploads/pskk/".$grp['sub']."/pskk_".$grp['db'].".db3";
  $db->open($fn);
  $d = $db->select('etc', 'name="viewaddki"');
  $viewaddki = (count($d)>0) ? $d[0]['val'] : 1;
  $db->close();
  $st  = strtotime($ymd); // ...................... 創業開始の日時
  $now = strtotime(Date('Y-m-d')); // ............. 現在の日時
  $edY = intval(Date('Y')) + $viewaddki + 1; // ... 終了の「年」
  $ki = 1; // ........ ループ内で使用する「期」の数値（ループ内で加算）
  $items = [];
  do {
    $ed = strtotime('+1 year -1 day', $st); // ... 会計年度の最終日のタイムスタンプ
    $ymdST = date('Y-m-d', $st); // .............. 会計年度の開始日の「年月日」
    $ymdED = date('Y-m-d', $ed); // .............. 会計年度の最終日の「年月日」
    if( $nowKI > 0 ){ // ......................... 会計年度の「期」の指定があれば
      $sel = ( $nowKI==$ki ) ? 'selected' : ''; // ... ループ中の「期」を選択値とする
    }elseif( $now>=$st and $now<=$ed ){ // ....... それ以外で、くり返し期間に「現在の日時」が含まれるなら
      $sel = 'selected'; // その期を選択値とする
      $nowKI = $ki; // 選択地とした値を返す
    }else{ // .................................... それ以外
      $sel = '';
    }
    $txt = '第 '.$ki.' 期（'.$ymdST.' ～ '.$ymdED.'）';
    $att = [];
    $att[] = 'value="'.$ki.'"';
    $att[] = 'data-st="'.$ymdST.'"';
    $att[] = 'data-ed="'.$ymdED.'"';
    if( $sel!="" ) $att[] = $sel;
    $items[] = '<option '.implode(' ', $att).'>'.$txt.'</options>';
    $y = intval(date('Y', strtotime($ymdED)));
    $st = strtotime('+1 year', $st );
    $ki++;
  }while( $y < $edY );
  $items = array_reverse($items);
  $att = [];
  $att[] = 'id="nendo"';
  // $att[] = 'date-add="'.$viewaddki.'"';
  $att[] = 'date-edy="'.$edY.'"';
  // $x = '<!-- '.$fn.' -->';
  return '<select '.implode(' ', $att).'>'.implode('', $items).'</select>';
}
function postKoji($post){ // 工事の登録・更新
  global $db;
  $db->open($post['db_path']);
  $db->begin();
  $id  = $post['data']['id'];
  $hdr = $post['data']['hdr'];
  $bdy = $post['data']['bdy'];
  $log = [];
  if( $id==0 ){ // ... 新規登録
    try {
      if( count($hdr)>0 ){ // .................................... hdr() のデータがあれば
        $sql = $db->insertSql('main', $hdr);
        $r = $db->exec($sql);
        $n = $db->changes();
        $log[] = 'SQL : '.$sql;
        $log[] = 'Stat: res = '.$r.'  count = '.$n;
        if( $r===false ) throw new Exception($sql);

        if( count($bdy)>0 ){ // .................................. bdy() があれば（新規登録時は、bdy() のみはあり得ない）
          $mainid = $db->lastInsertID();
          $log[] = 'mainid : '.$mainid;
          foreach($bdy as $k=>$v){
            $v['mainid'] = $mainid;
            $sql = $db->insertSql('meisai', $v);
            $r = $db->exec($sql);
            $log[] = $sql;
            if( $r===false ) throw new Exception($sql);
          }
        }
      }
      $db->commit();
      $res = 'ok';
    }catch(Exception $e){
      $db->rollback();
      $res = '<div style="background-color:#E00; color:#FFF; text-align:center;">工事を登録できませんでした。</div><p>'.$e->getMessage().'</p>';
    }
  }else{ // .......... 更新
    try {
      if( $id==0 ) throw new Exception('工事No の指定がありません。');
      if( count($hdr)>0 ){ // .............. hdr がある場合
        $r = $db->update('main', $hdr, 'id='.$id);
        $n = $db->changes();
        $log[] = '[update-res] '.$r.' (changes : '.$n.')';
        $err = 'SQL: '.$db->sys['last_sql'].'<br>result: '.$r.'<br>changes: '.$n;
        if( $r===false ) throw new Exception($err);
      }
      if( count($bdy)>0 ){ // .............. bdy（明細）がある場合 ... ここでは、[予定]の明細だけしか来ない
        foreach($bdy as $k=>$v){
          if( preg_match('/^y_([0-3])_([0-9]+)$/', $k, $m) ){
            $w = [];
            $w[] = 'mainid='.$v['mainid'];
            $w[] = 'ku='.$v['ku'];
            $w[] = 'ks_id='.$v['ks_id'];
            $w[] = 'sb_id='.$v['sb_id'];
            // 指定箇所の明細が存在するか
            $where = implode(' AND ', $w);
            $d = $db->select('meisai', $where);
            $n = $db->changes();
            $log[] = ['[select-res]'=>$d];
            $err = 'SQL: '.$db->sys['last_sql'].'<br>result: '.$r.'<br>changes: '.$n;
            if( $d===false ) throw new Exception($err);
            if( count($d)>0 ){ // その行のデータが既に存在する場合
              $id = $d[0]['id'];
              $r = $db->update('meisai', $v, 'id='.$id);
              $n = $db->changes();
              $log[] = '[update-res] result: '.$r.'  changes : '.$n;
              $err = 'SQL: '.$db->sys['last_sql'].'<br>result: '.$r.'<br>changes: '.$n;
              if( $r===false ) throw new Exception($err);
            }else{
              $r = $db->insert('meisai', $v);
              $n = $db->changes();
              $log[] = '[insert-res] result: '.$r.'  changes : '.$n;
              $err = 'SQL: '.$db->sys['last_sql'].'<br>result: '.$r.'<br>changes: '.$n;
              if( $r===false ) throw new Exception($err);
            }
          }
        }
      }
      $db->commit();
      $res = 'ok';
    }catch(Exception $e){
      $db->rollback();
      $res = '<div style="background-color:#E00; color:#FFF; text-align:center;">工事を更新できませんでした。</div><p>'.$e->getMessage().'</p>';
    }
  }
  $db->close();
  return [
    'debug'=>['post'=>$post, 'log'=>$log],
    'res'=>$res
  ];
}
function postMeisai($post){ // 実施明細の「登録・更新・削除」
  global $db;
  $log = [];
  $db->open($post['db_path']);
  $db->begin();
  $data = $post['data'];
  $id = isset($data['id']) ? intval($data['id']) : 0;
  try {
    if( $id == 0 ){ // ................. [登録] 明細 id が 0 の場合は、新規登録
      $log[] = $db->insertSql('meisai', $data);
      $r = $db->insert('meisai', $data);
      $log[] = $r;
      if( $r===false ) throw new Exception('登録できませんでした。');
    }elseif( $post['del']=="1" ){ // ... [削除]
      $log[] = $db->deleteSql('meisai','id='.$id);
      $r = $db->delete('meisai','id='.$id);
      $log[] = $r;
      if( $r===false ) throw new Exception('削除できませんでした。');
    }else{ // .......................... [更新]
      unset($data['id']);
      $log[] = $db->updateSql('meisai', $data, 'id='.$id);
      $r = $db->update('meisai', $data, 'id='.$id);
      $log[] = $r;
      if( $r===false ) throw new Exception('更新できませんでした。');
    }
    $db->commit();
    $res = 'ok';
  }catch(Exception $e){
    $log[] = $e;
    $db->rollback();
    $res = '<div style="background-color:#E00; color:#FFF; text-align:center;">明細を登録できませんでした。</div><p>'.$e->getMessage().'</p>';
  }
  $db->close();
  // 処理後の明細データ再取得
  switch( $data['ku'] ){
    case 1: $d = getMeisai(['koji_id'=>$data['mainid'], 'ku'=>$data['ku'], 'ks'=>$data['ks_id'], 'sb'=>$data['sb_id'], 'db_path'=>$post['db_path']]); break;
    case 2: $d = getMeisai(['koji_id'=>$data['mainid'], 'ku'=>$data['ku'], 'db_path'=>$post['db_path']]); break;
  }
  return [
    'debug'=>['post'=>$post, 'log'=>$log, 'data'=>$data],
    'data' =>$d['res'],
    'res'  =>$res   // ok または エラー文
  ];
}
function detail($post){ // 工事詳細データを返す
  global $db;
  $id = $post['id'];
  $d = array();
  $db->open($post['db_path']);
  // hdr ... main 情報
  $hdr = $db->select('main', 'id='.$id);
  $d['hdr'] = $hdr[0];
  // hdr ... main の status
  $v = ($d['hdr']['status']=="") ? [] : json_decode($d['hdr']['status'], true);
  $d['hdr']['status'] = $v;
  // meisai 情報
  $m = $db->select('meisai', 'mainid='.$id, 'ku, jyun, date DESC');
  foreach($m as $v){
    switch($v['ku']){
      case 0: $key = 'y_'.$v['ks_id'].'_'.$v['sb_id']; break; // ... [予定] データは１つ
      case 1: $key = 'j_'.$v['ks_id'].'_'.$v['sb_id']; break; // ... [実施] データは複数
      case 2: $key = 'nyukin'; break; // ........................... [入金] 種別・細別の区分なく複数
    }
    $d[$key][] = $v;
  }
  $db->close();
  return [
    'debug'=>['post'=>$post],
    'res'=>$d
  ];
}
function delKoji($post){ // 工事の削除
  global $db;
  $id = $post['id'];
  $log = [];
  $db->open($post['db_path']);
  $db->begin();
  try {
    if( $id==0 ) throw new Exception('工事No が指定されていません。');
    // メイン
    $sql = $db->deleteSql('main', 'id='.$id);
    $r = $db->exec($sql); $n = $db->changes();
    $log[] = 'SQL : '.$sql;
    $log[] = 'Stat: res = '.$r.'  count = '.$n;
    if( $r===false ) throw new Exception('工事データ(main)が削除できませんでした。');
    // 明細
    $sql = $db->deleteSql('meisai', 'mainid='.$id);
    $r = $db->exec($sql); $n = $db->changes();
    $log[] = 'SQL : '.$sql;
    $log[] = 'Stat: res = '.$r.'  count = '.$n;
    if( $r===false ) throw new Exception('工事データ(meisai)が削除できませんでした。');
    $db->commit();
    $res = 'ok';
  }catch(Exception $e){
    $db->rollback();
    $res = '<div style="background-color:#E00; color:#FFF; text-align:center;">工事を削除できませんでした。</div><p>'.$e->getMessage().'</p>';
  }
  $db->close();
  return [
    'debug'=>['post'=>$post, 'log'=>$log],
    'res'=>$res
  ];
}
function selector($post){
  global $db;
  $inp = $post['inp'];
  if( preg_match('/^hdr_(.*)$/', $post['key'], $m) ){
    $fna = $m[1];
    $sql = "SELECT DISTINCT {$fna} FROM main WHERE {$fna} like '%{$inp}%'  ORDER BY {$fna}";
  }elseif( preg_match('/^m_(c[0-9]+)_([0-9]+)_([0-9]+)/', $post['key'], $m) ){
    $fna = 'koumoku';
    $col = $m[1];
    $ks  = $m[2];
    $sb  = $m[3];
    $where = "WHERE ku=0 AND ks_id={$ks} AND sb_id={$sb}";
    if( $inp!="" ) $where .= " AND {$fna} like '%{$inp}%'";
    $sql = "SELECT DISTINCT {$fna} FROM meisai {$where} ORDER BY {$fna}";
  }
  $db->open($post['db_path']);
  $dt = $db->sql($sql);
  $db->close();
  $res = [];
  foreach($dt as $v){
    $val = $v[$fna];
    if($val!="") $res[] = $val;
  }
  return [
    'debug'=>['post'=>$post, 'sql'=>$sql],
    'res'=>$res
  ];
}
function postOptions($post){
  global $db;
  $db->open($post['db_path']);
  $res = [];
  foreach($post['data'] as $k=>$v){ // フォームからの送信データを繰り返す
    $d = $db->select('etc', 'name="'.$k.'"');
    $res[] = [$k, $v, $d[0]];
    if( $d[0]['id']>0 ){
      $db->update('etc', array('val'=>$v), 'id='.$d[0]['id']);
    }else{
      $db->insert('etc', array('grp'=>'sys', 'name'=>$k, 'val'=>$v));
    }
  }
  $db->close();
  return ['res'=>$res];
}
function getOptions($post){
  global $db;
  $db->open($post['db_path']);
  $d = $db->select('etc');
  $db->close();
  $res = array();
  foreach($d as $v){
    $res[ $v['name'] ] = $v['val'];
  }
  return ['res'=>$res];
}
function getMeisai($post){ // 明細データを取得する ... ku:予定・実施　ks:種別no　sb:細別no
  global $db;
  $where = ''; // .................... 抽出条件
  if( isset($post['meisai_id']) ){ // ...................................... meisai_id 
    $where = 'id='.$post['meisai_id'];
  }elseif( isset($post['koji_id']) ){ // ................................... koji_id
    $where = 'mainid='.$post['koji_id'];
    if( preg_match('/^m_c4_([0-9]+)_([0-9]+)$/', $post['fld_name'], $m) ){ // ... fld_name が m_c4_*_* （ 実施金額 ）
      $where .= ' AND ku=1 AND ks_id='.$m[1].' AND sb_id='.$m[2];
    }elseif( preg_match('/^nk_([0-9]+)$/', $post['fld_name'], $m) ){ // ......... fld_name が nk_* （ 入金金額 ）
      // *************
    }else{
      if( isset($post['ku']) ) $where .= ' AND ku='.$post['ku']; // ............. ku （ 0:予定　1:実施 ）
      if( isset($post['ks']) ) $where .= ' AND ks_id='.$post['ks']; // .......... ks （ 種別No　0:材料費　1:労務費 ...）
      if( isset($post['sb']) ) $where .= ' AND sb_id='.$post['sb']; // .......... sb （ 細別No（種別内の行番号：0から））
    }
  }
  $order = isset($post['order']) ? $post['order'] : 'date DESC'; // ............. ソート順
  $db->open($post['db_path']);
  $d = $db->select('meisai', $where, $order);
  $db->close();
  return [
    'debug'=>['post'=>$post, 'where'=>$where],
    'res'=>$d
  ];
}
function koji_list($post){ // 会計年度（期）を指定して、工事データ（main）を返す
  // ※ 一覧表示の対象は、[工期(至)] が会計年度の範囲内にあるもの。
  // ※ 一覧表示の工期は、[工期(自)] 。
  global $db;
  $info = []; $log = [];
  $where = ($post['nendo']!="") ? where_ki($post['nendo'], $post['ymd_start'], 'date2') : "";
  $order = 'date1 DESC, id DESC';
  $addCol = ',kin1-g2 AS arari';
  $log[] = $where;
  $db->open($post['db_path']);
  $d = $db->select('main', $where, $order, "", "", "", $addCol);
  $e = $db->select('etc');
  $db->close();
  // その他の情報
  foreach($e as $v) $info[ $v['name'] ] = $v['val'];
  $info['lastupdate'] = date('Y-m-d H:i', filemtime($post['db_path'])); // ... db の最終更新日時
  $info['dbn'] = $post['dbn']; // ............................................ db名
  $info['dbpath'] = $post['db_path']; // ..................................... dbのパス
  return [
    'debug'=>['post'=>$post, 'log'=>$log],
    'data'=>$d,
    'info'=>$info
  ];
}
function where_ki($ki, $ymd, $fld){
  $ar = explode("-", $ymd);
	$yy_st = intval($ar[0]);
	$mm_st = intval($ar[1]);
	$dd_st = intval($ar[2]);
	$y1 = $yy_st + ($ki - 1);
	$m1 = $mm_st;
	$d1 = $dd_st;
	$ymd1 = date("Y-m-d", mktime(0,0,0, $m1, $d1, $y1));
	$ymd2 = date("Y-m-d", strtotime("-1 day", mktime(0,0,0, $m1, $d1, $y1+1)));
	if($fld!=""){
		$ret = $fld." >= '".$ymd1."' AND ".$fld." <= '".$ymd2."'";
	}else{
		$ret = $ymd1." ～ ".$ymd2;
	}
	return $ret;
}
// ------------------------------
function _err($post){ // エラー時の job
    return [
        'debug'=>['post'=>$post, 'set'=>$set],
        'tag'=>'not found job name ... "'.$post['job'].'"'
    ];
}
function _set($post, $deli="-", $pos=2){ // 設定ファイル(json)の読み込み
    $na = $post['set'];
    $dirM = 'set/';
    $dirD = _dir([$post['subdir'], 'set']);
    $part = explode($deli, SETFILE_PRE.$na);
    $info = [];
    $data = [];
    foreach($part as $n=>$v){
        $dir = ($n < $pos) ? $dirM : $dirD;
        $sl = array_slice($part, 0, $n + 1);
        $fn = $dir.implode($deli, $sl).'.json';
        $ex = file_exists($fn) ? true : false;
        if($ex){
            $d = json_decode( file_get_contents($fn), true);
            $data = array_replace_recursive($data, $d);
        }
        $info[] = ['ex'=>$ex, 'fn'=>$fn];
    }
    return ['data'=>$data, 'stat'=>$info];
}
function _dir($e="", $base="data", $mode=""){
    $d = explode('/-/', __DIR__);
    $sub = (is_array($e)) ? implode('/', $e) : $e; if($sub!="") $sub .= '/';
    $r = ($mode==="html") ? "" : $d[0];
    $ret = $r.'/-/'.$base.'/'.$sub;
    return $ret;
}
function _attr(){ // attr(タグの属性) を作成 2019-11-10
    $at = [];
    $ret = [];
    $p = func_get_args();
    foreach($p as $v){ if( $v!==null ) $at = array_merge_recursive($at, $v); }
    //
    foreach($at as $key=>$v){
        $v = $at[$key];
        switch($key){
            case 'class':
                $d = (is_array($v)) ? implode(' ', $v) : $v;
                if($d!="") $ret[] = "{$key}=\"{$d}\"";
                break;
            case 'data':
                if( is_array($v) ){
                    foreach($v as $k=>$d) $ret[] = $key.'-'.$k.'="'.$d.'"';
                }
                break;
            case 'style':
                if( is_array($v) ){
                    $itm = [];
                    foreach($v as $k=>$d) $itm[] = $k.':'.$d;
                    $ret[] = $key.'="'.implode('; ', $itm).'"';
                }
                break;
            default:
                if($v!="") $ret[] = $key.'="'.$v.'"';
                break;
        }
    }
    return (count($ret)>0) ? ' '.implode(' ', $ret) : '';
}
function _encData($dbFields, $data){ // 配列データを保存用の配列データに加工する（１レコード分）
    $etc = []; // 実フィールド以外のデータの保存用
    $ret = [];
    foreach($data as $k=>$v){
        if( array_key_exists($k, $dbFields) ){ // 実在するフィールドなら
            $ret[$k] = $v;
        }else{
            $etc[$k] = $v;
        }
    }
    $ret['etc'] = json_encode($etc, JSON_HEX_QUOT | JSON_HEX_APOS | JSON_UNESCAPED_UNICODE);
    return $ret;
}
function cStr($data){ // 配列であれば結合して文字列に
    return (is_array($data)) ? implode('', $data) : $data;
}
function sel_spc(){ // 複数の候補から値を決める ... いずれも empty() の場合 
    $a = func_get_args();
    $ret = null;
    foreach($a as $v){
        if(!empty($v)){ $ret = $v; break;}
    }
    if($ret===null) $ret = "";
    return $ret;
}