#
# 工事メイン（工事計画書） ... １工事あたり１つ
#
CREATE TABLE main (
  id INTEGER PRIMARY KEY,
  date0 TEXT,     # 契約年月日
  date1 TEXT,     # 工事開始日
  date2 TEXT,     # 工事終了日
  name TEXT,      # 工事名
  place TEXT,     # 工事場所
  tanto TEXT,     # 担当
  kin0 NUMERIC,   # 受注金額
  kin1 NUMERIC,   # 受注金額（税込）
  g1 NUMERIC,     # 予定工事費合計
  g2 NUMERIC,     # 実施工事費合計(支払合計)
  g3 NUMERIC,     # 入金合計
  p1 NUMERIC,     # 率１(総工事費率)
  p2 NUMERIC,     # 率２(支払比率)
  p3 NUMERIC,     # 率３(粗利率)
  taxp NUMERIC,   # 税率
  gst_id INTEGER, # 発注元ID
  gst_name TEXT,  # 発注元名
  status TEXT,    # 各種情報 Ver2.0
  memo TEXT);
CREATE INDEX idx_kjm_date0 ON main(date0);
CREATE INDEX idx_kjm_date2 ON main(date2);
CREATE INDEX idx_kjm_gid ON main(gst_id);
CREATE INDEX idx_kjm_gname ON main(gst_name);
CREATE INDEX idx_kjm_place ON main(place);
#
# 明細
#
CREATE TABLE meisai (
  id INTEGER PRIMARY KEY,
  mainid INTEGER, # 工事メインID
  date TEXT,      # 日付
  ku NUMERIC,     # 区分 ... 0:予定　1:実施　2:入金
  jyun INTEGER,   # 表示順
  ks_id INTEGER,  # 工事種別id
  ks_name TEXT,   # 工事種別名
  sb_id INTEGER,  # 細別id
  sb_name TEXT,   # 細別名
  koumoku TEXT,   # 項目名
  kin NUMERIC,    # 金額
  memo TEXT);
CREATE INDEX idx_meisai_mainid ON meisai(mainid);
CREATE INDEX idx_meisai_ku ON meisai(ku);
CREATE INDEX idx_meisai_date ON meisai(date);
#
# 顧客
#
CREATE TABLE guest (
	id INTEGER PRIMARY KEY,
	grp TEXT,
	code NUMERIC,
	name TEXT,
	furi TEXT,
	keisyo TEXT,
	tag TEXT,
	tel TEXT,
	zip TEXT,
	adr TEXT,
	memo TEXT);
CREATE INDEX idx_gu_grp ON guest(grp);
CREATE INDEX idx_gu_furi ON guest(furi);
CREATE INDEX idx_gu_tel ON guest(tel);
CREATE INDEX idx_gu_tag ON guest(tag);
#
# 工事種別
#
CREATE TABLE ks (
	id INTEGER PRIMARY KEY,
	code NUMERIC,
	jyun NUMERIC,
	name TEXT,
	memo TEXT);
CREATE INDEX idx_ks_code ON ks(code);
INSERT INTO ks (code, jyun, name) VALUES(0, 10, '材料費');
INSERT INTO ks (code, jyun, name) VALUES(1, 20, '労務費');
INSERT INTO ks (code, jyun, name) VALUES(2, 30, '現場管理費');
INSERT INTO ks (code, jyun, name) VALUES(3, 40, '一般管理費');
#
# 細別
#
CREATE TABLE sb (
	id INTEGER PRIMARY KEY,
	ks_code NUMERIC,
	code NUMERIC,
	jyun NUMERIC,
	name TEXT,
	memo TEXT);
INSERT INTO sb (ks_code, jyun, name) VALUES(0, 10, '下塗塗装');
INSERT INTO sb (ks_code, jyun, name) VALUES(0, 20, '中塗塗装');
INSERT INTO sb (ks_code, jyun, name) VALUES(0, 30, '上塗塗装');
INSERT INTO sb (ks_code, jyun, name) VALUES(0, 40, '希釈剤');
INSERT INTO sb (ks_code, jyun, name) VALUES(0, 50, 'その他');
INSERT INTO sb (ks_code, jyun, name) VALUES(1, 10, '塗装工');
INSERT INTO sb (ks_code, jyun, name) VALUES(1, 20, '足場工');
INSERT INTO sb (ks_code, jyun, name) VALUES(1, 30, '主任技術者');
INSERT INTO sb (ks_code, jyun, name) VALUES(1, 40, '現場代理人');
INSERT INTO sb (ks_code, jyun, name) VALUES(1, 50, 'その他');
INSERT INTO sb (ks_code, jyun, name) VALUES(2, 10, '工事看板');
INSERT INTO sb (ks_code, jyun, name) VALUES(2, 20, 'リース費');
INSERT INTO sb (ks_code, jyun, name) VALUES(2, 30, '塗装面積費');
INSERT INTO sb (ks_code, jyun, name) VALUES(2, 40, 'ガードマン費');
INSERT INTO sb (ks_code, jyun, name) VALUES(2, 50, '借地代');
INSERT INTO sb (ks_code, jyun, name) VALUES(2, 60, '宿泊費');
INSERT INTO sb (ks_code, jyun, name) VALUES(2, 70, '写真代');
INSERT INTO sb (ks_code, jyun, name) VALUES(2, 80, '労災保険');
INSERT INTO sb (ks_code, jyun, name) VALUES(2, 90, '建退共');
INSERT INTO sb (ks_code, jyun, name) VALUES(2, 100, '保険料');
INSERT INTO sb (ks_code, jyun, name) VALUES(2, 110, '現場旅費');
INSERT INTO sb (ks_code, jyun, name) VALUES(2, 120, '雑費');
INSERT INTO sb (ks_code, jyun, name) VALUES(2, 130, 'その他');
INSERT INTO sb (ks_code, jyun, name) VALUES(3, 10, '営業経費');
INSERT INTO sb (ks_code, jyun, name) VALUES(3, 20, '専門会費');
INSERT INTO sb (ks_code, jyun, name) VALUES(3, 30, '九州鋼構造');
INSERT INTO sb (ks_code, jyun, name) VALUES(3, 40, '保証料');
INSERT INTO sb (ks_code, jyun, name) VALUES(3, 50, '旅費');
INSERT INTO sb (ks_code, jyun, name) VALUES(3, 60, 'その他');
#
# その他情報
#
CREATE TABLE etc (
	id INTEGER PRIMARY KEY,
	grp TEXT,
	code NUMERIC,
	name TEXT,
	val TEXT);
CREATE INDEX idx_user_grp ON etc(grp);
CREATE INDEX idx_user_name ON etc(name);
INSERT INTO etc (grp, name, val) VALUES('sys', 'taxp', '10');
INSERT INTO etc (grp, name, val) VALUES('sys', 'listdayfld', 'date1');
INSERT INTO etc (grp, name, val) VALUES('sys', 'listmax', '50');
INSERT INTO etc (grp, name, val) VALUES('sys', 'listrows', '10,50,100');
