/*!
	pskk:v2.js
	Ver.: 2.1
	Date: 2018-03-03
	by Parallel Soft
*/
$(document).ready(function(e) {
	// ユーザーチェック
	syncPost('job=check_user', function(e){
		if( isJSON(e) ){
			var p = JSON.parse(e);
			$("#pskk_contents").attr({
				'data-start':p['st'],
				'data-name':p['na'],
				'data-ki':age(p['st']),
				'data-dbn':p['dbn'],
				'data-err':''
			});
		}else{
			$("#pskk_contents").attr({'data-err':e});
		}
	});
	var st = $("#pskk_contents").attr('data-start');
	var ki = $("#pskk_contents").attr('data-ki');
	if( st===undefined ){
		//showErr();
		// $("#pskk_contents").psLogin({
		// 	serverScript: '/wp-content/plugins/pskk/psh_site.php'
		// });
	}else{
		showListKoji();
	}
});
function checkChangeAll(){ // 変更箇所(クラス名 change の数)をカウント
	var obj = $("#pskk_detail"),
		cngHdr = obj.find('[name^="hdr_"].change').length,	// ヘッダ 変更数
		cngMei = obj.find('[name^="m_"].change').length,	// 明細 変更数
		cntAll = cngHdr + cngMei,
		msg = (cntAll==0) ? '' : jstr(27)+cntAll;
	obj.attr({
		'data-change-hdr':cngHdr,
		'data-change-mei':cngMei
	});
	$("#pskk_navir span.stat").text(msg); // 変更数をメッセージで表示
	if( cntAll>0 ){
		$(window).on('beforeunload', function(){ return jstr(26); });
	}else{
		$(window).off('beforeunload');
	}
}
function eventBlur(obj, chkChange){ // .blur の動作 ... 内容が変更されたかどうかも確認
	if( chkChange===undefined ) chkChange = true;
	obj.removeClass('focus');
	// 比較
	if( obj.hasClass('cur') ){ // 金額の場合 ... 
		var n = obj.val().replace(/[^\d\-]/g,''); if(n=='') n = '0';
		var cng = ( parseInt(n)===parseInt(obj.attr('data-def')) ) ? false : true ;
		setValueNum( obj, n);
	}else if( obj.hasClass('chk') ){ // チェックボックスの場合

	}else{
		var cng = ( obj.val()==obj.attr('data-def') ) ? false : true ;
	}
	//
	if( chkChange && cng ){
		obj.addClass('change');
		obj.attr({'title':obj.attr('data-def')});
	}else{
		obj.removeClass('change');
		obj.attr({'title':''});
	}
	// 契約金額(税別) を変更した場合のみ、税込み額の項目も
	if( obj.attr('name')=='hdr_kin0' && chkChange===true){
		var o = $('#pskk_detail input[name="hdr_kin1"]');
		if( cng ){ o.addClass('change');}else{ o.removeClass('change');}
	}
}
function eventFocus(obj){
	obj.addClass('focus');
	obj.select();
}
function jobDetailToList(){ // 一覧へ戻る際の処理（変更確認・保存）
	// 変更箇所のチェック
	var objDt = $("#pskk_detail");
	var cnt = 0;
	cnt += parseInt(objDt.attr('data-change-hdr'));
	cnt += parseInt(objDt.attr('data-change-mei'));
	if( cnt>0 ){ // 変更があれば
		var opt = $("#pskk_options_area");
		opt.html(jstr(43))
			.dialog({
				width:400, modal:true, title:jstr(44), autoOpen:true, resizable:false,
				position:{my:"center top", at:"center top", of:$("#pskk_tabs") },
				buttons:{
					'保存して一覧へ': function(){
						var objChk = objDt.find('input[name="hdr_date2"]'); // 工期(至)
						if( !isDate(objChk.val()) ){
							opt.dialog("close");
							alert(jstr('no_koki_ed'));
							objChk.focus();
						}else{
							postData();
							$(window).off('beforeunload');
							opt.dialog("close");
							showListKoji();
						}
					},
					'保存せず一覧へ': function(){
						$(window).off('beforeunload');
						opt.dialog("close");
						showListKoji();
					},
					'キャンセル': function(){
						opt.dialog("close");
					}
				}
			});
	}else{ showListKoji(); }
}
function showErr(){ // エラー内容によって表示を分ける
	var obj = $("#pskk_contents");
	var s = obj.attr('data-err');
	var err = (s.split(':'))[1];
	switch(err){
		case 'not login': // ログインしていない -----------------------------------
			obj.html( tmp_login );
			obj.find("button.submit").click(function(e) {
				var uid = obj.find("input[name=uid]").val();
				var upw = obj.find("input[name=upw]").val();
				var c1  = obj.find("input[name=c1]").val();
				sysLogin('job=login&fld_un='+uid+'&fld_pw='+upw+"&c1="+c1, function(e){
					if( e=='ok' ){
						window.location.reload();
					}else{
						alert(jstr('cant_login')+' ('+e+')');
					}
				});
			});
			break;
		case 'unable user': // ログインしているが、利用可能なユーザーではない -----
			$("#pskk_contents").html( tmp_unable_user );
		// 	$('#pskk_contents button').click(function(e) {
		// 		sysLogin('job=logout', function(e){
		// 			if( e=='ok' ){
		// 				window.location.reload();
		// 			}else{
		// 				alert(jstr('cant_logout')+' ('+e+')');
		// 			}
		// 		});
        //    });
			break;
	}
}
function showDebug(str){ $("#hdr_id .debug").text( ' ['+str+']' );}
function showMessage(e){ // エラー内容から表示内容に変換
	var err = (e.split(':'))[1];
	return jstr(err);
}
function showDetail(id){ // 工事の詳細表示
	asyncPost('job=syubetu', function(e){ // [種別]を読み込んで、枠を表示
		if( isJSON(e) ){
			var p = JSON.parse(e);
			$("#pskk_contents").html( tmp_detail );	// ベース表示
			var detail = $("#pskk_detail");
			var idx = detail.find("[tabindex]").length + 1; // 明細の tabindex の開始値 (これまで表示した内容のtabindex個数+1)
			$("#main_list tbody").html( tmp_kssb(p, idx) ); // tbody に明細を表示
			$("#nyukin_meisai tbody").html( tmp_nyukin_meisai() );
			var idx = detail.find("[tabindex]").length + 1; // 明細の tabindex の開始値 (これまで表示した内容のtabindex個数+1)
			$('#bikou input[name="hdr_tanto"]').attr({'tabindex':idx++});
			$('#bikou textarea[name="hdr_memo"]').attr({'tabindex':idx});
			var tabindex_last = idx;
			// [種別]名を記録 ... 実施明細の選択肢で利用
			var ksna  = [];
			$.each(p, function(index, v){ ksna[index] = v['name']; });
			$("#main_list").attr({'data-ks':ksna.join(',')});
			// 形状調整 ... 備考の高さ
			var h = $("#bikou").parent('td').outerHeight(); // 外側の枠の高さ
			h -= $("#nyukin_meisai").outerHeight(); // 入金明細の高さ
			h -= $("#bikou thead").outerHeight(); // ヘッダの高さ
			h -= $("#bikou tfoot").outerHeight(); // フッタの高さ
			$("#bikou tbody td").height(h);
			detail.find("input.date").datepicker(); // Datetime Picker 定義
			// ------ event -------
			// 明細タブ
			$("#pskk_tabs ul li.tab div")
				.click(function(e) {
					var tab_index = $("#pskk_tabs").attr('data-index');
					var this_index = $(this).parent().index();	// 現在のタブ番号
					if( this_index != tab_index ){				// 
						tab_index = this_index;
						$('article').hide().eq(tab_index).fadeIn('fast');	// 全てのタブ内容を非表示にして、選択したタブ内容のみを表示
						$('#pskk_tabs li').removeClass('selected').eq(tab_index).addClass('selected'); // タブの選択状態を変更
						$("#pskk_tabs").attr({'data-index':tab_index});
						switch(tab_index){
							case 1: showListJAll(id); break; // tab1 実施明細を表示
							// case 2: makuatsuShowForm(id); break; // tab2 塗膜厚
						}
					}
					hidePopup();
				});
			// 各 edit フィールド
			detail.find("input.edit")
				.keyup(function(e) {
					var c = e.which ? e.which : e.keyCode;
					switch(c){
						case 13: // Enter で次の項目へ移動
							if( $(this).attr('name').match(/^hdr_([a-z0-9_]+)$/) ){ // ヘッダ・担当・備考でEnter
								var next_idx = parseInt($(this).attr('tabindex')) + 1;
								detail.find('[tabindex='+next_idx+']').focus();
							}else if( $(this).attr('name').match(/^m_c([0-2])_([0-9_]+)$/) ){ // 予定明細でEnter
								switch(parseInt(RegExp.$1)){ // 0:細別名　1:項目名　2:金額
									case 0: $('input[name=m_c1_'+RegExp.$2+']').focus(); break;
									case 1:
									case 2:
										var next_idx = parseInt($(this).attr('tabindex')) + 1;
										if( next_idx===tabindex_last ) next_idx = 1;
										$('[tabindex='+next_idx+']').focus();
										break;
								}
							}
							break;
						case 38: hidePopup(); break; // ------------ [↑] でリストを閉じる
						case 40: showListY( $(this) ); break; // --- [↓] でリストを開く
					}
				})
				.click(function(e) { hidePopup();})
				.focus(function(e) {
					var my = $(this);
					eventFocus(my);
					if( my.hasClass('list') ){ showBtnKoumokuSelect(my); }
				})
				.blur(function(e) {
					var my = $(this),
						na = my.attr('name');
					if( my.hasClass('list') && !$("#listboxButton").hasClass('hover') ){ showBtnKoumokuSelect();}
					eventBlur(my);
					// 再計算
					if( na=='hdr_kin0' ){ // 契約金額
						recalc(3);
					}else if( na=='hdr_taxp' ){ // 消費税率
						recalc(3);
					}else if( na.match(/^m_c2_([0-9]+)_([0-9]+)$/) ){ // 予定金額
						recalc(0, RegExp.$1);
					}
					checkChangeAll(); // 変更箇所をチェック
				});
			$("textarea.edit")
				.focus(function(e) {
					hidePopup();
					eventFocus($(this));
				})
				.blur(function(e) {
					eventBlur($(this), detail.hasClass('update'));
					if( $("#pskk_detail").hasClass('update') ) checkChangeAll(); // 全ての変更箇所をチェック
				});
			// 実施明細クリック
			$("#main_list .list2").click(function(e) {
				if( $("#pskk_detail").hasClass('update') ){ // 変更時のみ
					var na = $(this).attr('name');
					if( na.match(/^m_c([34])_([0-9]+)_([0-9]+)$/) ){
						var tg1 = $('#main_list input[name="m_c3_'+RegExp.$2+'_'+RegExp.$3+'"]');
						var tg2 = $('#main_list input[name="m_c4_'+RegExp.$2+'_'+RegExp.$3+'"]');
						hidePopup(); // 一旦閉じる（前回の残骸を表示しないため）
						tg1.addClass('selected');
						tg2.addClass('selected');
						showListJ( $(this) );
					}
				}
			});
			// 入金明細
			$("#nyukin_meisai .list2").click(function(e) {
				if( $("#pskk_detail").hasClass('update') ){ // 変更時のみ
					var na = $(this).attr('name');
					if( na.match(/^n[dk]_([0-9]+)$/) ){
						var tg1 = $('#nyukin_meisai input[name="nd_'+RegExp.$1+'"]');
						var tg2 = $('#nyukin_meisai input[name="nk_'+RegExp.$1+'"]');
						hidePopup(); // 一旦閉じる（前回の残骸を表示しないため）
						tg1.addClass('selected');
						tg2.addClass('selected');
						showDetailN(tg2); // 入金明細は１つのデータなので一覧は無し
					}
				}
            });
			// 選択リスト表示ボタン
			$("#listboxButton")
				.mouseover(function(e) { $(this).addClass('hover'); })
				.mouseout(function(e) { $(this).removeClass('hover'); })
				.click(function(e) {
					showListY( $(this) );
					$(this).hide();
				});
			// [一覧へ戻る]ボタンクリック
			$("#toolbar button.tolist").click(function(e) { jobDetailToList(); });
			// [更新]ボタン
			$('#pskk_navir button.post').click(function(e) {
				postData();
				$(window).off('beforeunload');
            });
			// [工事削除]ボタン
			$("#pskk_delkoji").click(function(e) {
                if( confirm(jstr('delkoji')) ){
					asyncPost('job=koji_del&id='+$("#hdr_id .id").text(), function(e){
						if(e=='ok'){ showListKoji();}else{alert(e);}
					});
				}
            });
			// --- data -----
			if( id===undefined ){ // 新規の場合
				var setValAttr = function(obj, val){ obj.val(val).attr({'data-def':val}); };
				detail.attr({'class':'new'});
				detail.find('#pskk_navir button.post').text(jstr('save'));
				detail.find('#pskk_tabs li:nth-child(2)').hide(); // 実施明細一覧タブを隠す
				//detail.find('#pskk_tabs li:nth-child(3)').hide(); // 塗膜厚タブを隠す
				$("#pskk_delkoji").hide(); // 工事削除ボタンを隠す
				// 各項目の初期値
				detail.find('.fld').each(function(index, element) {
					if( $(this).attr('name')=='hdr_p3' ){
						$(this).attr({'data-def':100});
					}else if( $(this).hasClass('cur') || $(this).hasClass('per') ){
						$(this).attr({'data-def':0});
					}else{
						$(this).attr({'data-def':''});
					}
				});
				// 工事内設定値
				asyncPost('job=etc', function(e){
					if( isJSON(e) ){
						var p = JSON.parse(e);
						setValAttr($('#tab_contents_etc input[name="hdr_taxp"]'), p['taxp']); // 消費税率
					}else{ alert(e);}
				});
			}else{
				detail.attr({'class':'update'});
				detail.find('#pskk_navir button.post').text(jstr(21));
				$("#hdr_id span.id").text(id);
				_values(id); // 値の表示
			}
			detail.find('button').button();
		}else{
			$("#pskk_contents").html('<div class="err">'+showMessage(e)+'</div>');
		}
	});
	// 値の表示 ======================
	var _values = function(id){
		asyncPost('job=detail&id='+id, function(e){
			var p = JSON.parse(e),
				obj = $("#pskk_detail input, #pskk_detail textarea"),
				total = {'y0':0, 'y1':0, 'y2':0, 'y3':0, 'j0':0, 'j1':0, 'j2':0, 'j3':0, 'n':0, 'g0':0, 'g1':0, 'g2':0};
			$.each(obj, function(index, element){
				var my = $(this),
					na = (my.attr('name')!==undefined) ? my.attr('name') : '-';
				if( na.match(/hdr_([a-z0-9_]+)/) ){							// ヘッダ部分の表示 ----
					var key = RegExp.$1,
						val = function(){
							if( p['hdr'][key] ){
								return p['hdr'][key];
							}else if( p['hdr']['status'][key] ){
								return p['hdr']['status'][key];
							}else{
								return '';
							}
						}
					my.attr({'data-def':val()});
					setValueNum(my, val());
				}else if( na.match(/m_c0_([0-9]+)_([0-9]+)/) ){				// m_c0 ... 細別名
					var v = p['y_'+RegExp.$1+'_'+RegExp.$2][0]['sb_name'];
					my.val(v).attr({'data-def':v});
				}else if( na.match(/m_c1_([0-9]+)_([0-9]+)/) ){				// m_c1 ... 予定項目名
					var v = p['y_'+RegExp.$1+'_'+RegExp.$2][0]['koumoku'];
					my.val(v).attr({'data-def':v});
				}else if( na.match(/m_c2_([0-9]+)_([0-9]+)/) ){				// m_c2 ... 予定金額
					var v = p['y_'+RegExp.$1+'_'+RegExp.$2][0]['kin'];
					setInt( my, v, 1);
				}else if( na.match(/m_c3_([0-9]+)_([0-9]+)/) ){				// m_c3 ... 実施項目名(最新の日付と項目名)
					var key = String('j_'+RegExp.$1+'_'+RegExp.$2);
					if( p[key]===undefined ){
						var v = '';
					}else if(p[key][0]['date']!==""){
						var v = cDateYM(p[key][0]['date'])+' '+p[key][0]['koumoku'];
					}else{
						var v = p[key][0]['koumoku'];
					}
					my.val(v);
				}else if( na.match(/m_c4_([0-9]+)_([0-9]+)/) ){				// m_c4 ... 実施金額合計
					var key = String('j_'+RegExp.$1+'_'+RegExp.$2);
					if( p[key]===undefined ){
						var v = 0;
					}else{
						var v = 0;
						for(var i=0; i<p[key].length; i++){
							v += p[key][i]['kin'];
						}
					}
					setInt( my, v);
				}
			});
			// 入金
			if( p['nyukin']!==undefined ){
				for(var i=0; i<p['nyukin'].length; i++){
					var obj = $("#nyukin_meisai");
					var f1 = obj.find('input[name="nd_'+i+'"]');
					var f2 = obj.find('input[name="nk_'+i+'"]');
					f1.val( cDateYM(p['nyukin'][i]['date']) ); // 日付
					setValueNum( f2, p['nyukin'][i]['kin']);   // 金額
					total['n'] += p['nyukin'][i]['kin'];
					f1.attr({'data-id':p['nyukin'][i]['id'], 'title':p['nyukin'][i]['koumoku']});
					f2.attr({'data-id':p['nyukin'][i]['id'], 'title':p['nyukin'][i]['koumoku']});
				}
			}
			// 合計の表示
			for(var i=0; i<4; i++){
				recalc(0, i); // 予定合計
				recalc(1, i); // 実施合計
			}
			recalc(2);
			checkChangeAll();
		});
	}
}
function showDetailJ(tg, id, mode){ // 実施明細の詳細編集用 ... tg:表示位置の基準　id:実施明細のid
	var obj = $("#jdetailbox");
	obj.attr({'data-name':tg.attr('name')});
	obj.html( tmp_jDetail ).show();	// 表示
	var stat = ( id===undefined ) ? 'new' : 'update';
	var isNewWin = ( id===undefined ) ? true : false;
	obj.find("table").addClass(stat);
	obj.find("input.date").datepicker();
	var x = tg.offset().left + tg.outerWidth(true) - obj.outerWidth(true);
	var y = tg.offset().top + tg.outerHeight(true);
	obj.css({left:x, top:y});
	// --- event ---
	obj.find("input.fld")
		.keyup(function(e) {
			var c = e.which ? e.which : e.keyCode;
			var na = $(this).attr('name');
			if( c==13 ){
				switch(na){
					case 'dat': $('#jdetailbox input[name="kou"]').focus(); break;
					case 'kou': $('#jdetailbox input[name="kin"]').focus(); break;
					case 'kin': $('#jdetailbox input[name="dat"]').focus(); break;
				}
			}
		})
		.focus(function(e) { eventFocus($(this), !isNewWin); })
		.blur(function(e) { eventBlur($(this), !isNewWin); });
	obj.find(".close_btn")
		.click(function(e) { hidePopup(); });
	obj.find('button.post')
		.click(function(e) {
			var mainid = $("#hdr_id .id").text();
			var ks = parseInt(obj.find(".ks").text());
			var sb = parseInt(obj.find(".sb").text());
			var vDat = obj.find("input.fdat").val();
			var vKou = obj.find("input.fkou").val();
			var vKin = cInt(obj.find("input.fkin").val());
			var sb_obj = $('#main_list input[name="m_c0_'+ks+'_'+sb+'"]');
			var sb_name = sb_obj.val();
			var ks_name = sb_obj.attr('data-ksname');
			if( isNewWin ){										// 追加 -------------------
				var d = { 'mainid':mainid, 'ku':1, 'jyun':0, 'ks_id':ks, 'sb_id':sb, 'ks_name':ks_name, 'sb_name':sb_name,
						  'date':vDat, 'koumoku':vKou, 'kin':vKin};
				var data = JSON.stringify(d);
				asyncPost('job=meisai_add&data='+data, function(e){
					recalcJ(mainid, ks, sb); // 実施明細の再計算・表示
				});
			}else{
				if( obj.find('input.del').prop('checked') ){	// 削除 -------------------
					if( confirm(jstr(31)) ){
						asyncPost('job=meisai_del&id='+id, function(e){
							if( e=='ok' ){
								recalcJ(mainid, ks, sb); // 再計算・再表示
								if( mode===1 ) showListJAll(mainid);
							}else{
								alert(jstr(32));
							}
						});
					}
				}else{											// 更新 -------------------
					if( obj.find('input.change, select.change').length > 0 ){	// 変更箇所があれば
						var d = { 'date':vDat, 'koumoku':vKou, 'kin':vKin, 'ks_name':ks_name, 'sb_name':sb_name, 'ks_id':ks, 'sb_id':sb};
						var data = JSON.stringify(d);
						var ks0 = obj.find('select[name="ks"]').attr('data-def');
						var sb0 = obj.find('select[name="sb"]').attr('data-def');
						asyncPost('job=meisai_update&id='+id+'&data='+data, function(e){
							recalcJ(mainid, ks, sb);   // 実施明細の再計算・表示
							if( mode===1 ){
								recalcJ(mainid, ks0, sb0);
								var o = $("#ku1_list tr[data-id="+id+"]");
								o.find('td.dat').text(vDat);
								o.find('td.kou').text(vKou);
								o.find('td.kin').text(ccur(vKin));
								o.find('td.ksn').text(ks_name);
								o.find('td.sbn').text(sb_name);
							}
						});
					}
				}
			}
			hidePopup();
    	});
	// --- data --- event定義の後で表示させる
	if( isNewWin ){
		obj.find('div.del').hide(); // 工事新規登録時は、[削除]ボタンは消す
		obj.find("caption").text(jstr(33));
		obj.find("button.post").text(jstr(34));
		obj.find(".id").text( $("#hdr_id .id").text() ); /* 工事id */
		var v = obj.attr('data-name').split('_');
		obj.find(".ks").text(v[2]);
		obj.find(".sb").text(v[3]);
		obj.find("input.fdat").focus();
	}else{
		obj.find("caption").text(jstr(35));
		obj.find("button.post").text(jstr(21));
		asyncPost('job=jdetail&id='+id, function(e){
			if( isJSON(e) ){
				var v = JSON.parse(e);
				obj.find(".id").text(id); /* 明細id */
				obj.find(".ks").text(v['ks_id']);
				obj.find(".sb").text(v['sb_id']);
				obj.find("input.fdat").val(v['date']).attr({'data-def':v['date']}).focus();
				obj.find("input.fkou").val(v['koumoku']).attr({'data-def':v['koumoku']});
				obj.find("input.fkin").attr({'data-def':v['kin']});
				setValueNum(obj.find("input.fkin"), v['kin']);
				//
				if( mode===1 ){ // 実施明細一覧では、[種別] [細別] を変更可能
					obj.find('.select').html('種別:<select name="ks"></select><br>細別:<select name="sb"></select>');
					var oKS = obj.find('.select select[name="ks"]');
					var oSB = obj.find('.select select[name="sb"]');
					oKS.attr({'data-def':v['ks_id']});
					oSB.attr({'data-def':v['sb_id']});
					var setSB = function(ks){
						oSB.children().remove();
						var items = $('#main_list input[name^="m_c0_'+ks+'_"]');
						$.each(items, function(index, element) {
 							var isSelected = (index===v['sb_id']);
							$option = $('<option>')
								.val(index)
								.text( $(this).val() )
								.prop('selected', isSelected);
							oSB.append($option);
                        });
					}
					var d = $("#main_list").attr('data-ks').split(',');
					$.each(d, function (key, val) {
						var isSelected = (key === v['ks_id']);
						$option = $('<option>')
							.val(key)
							.text(val)
							.prop('selected', isSelected);
						oKS.append($option);
					});
					setSB(v['ks_id']);
					//
					oKS.change(function(e) { // [種別] を変更した場合
						var vKS = parseInt($(this).val(),10); // 選択した値
						setSB(vKS); // [細別] の選択肢を更新
						var vSB = parseInt(oSB.val(),10); // 更新後の値
						obj.find(".ks").text(vKS);
						obj.find(".sb").text(vSB);
                        if( v['ks_id'] == vKS ){
							oKS.removeClass('change');
							if( v['sb_id'] == vSB ){
								oSB.removeClass('change');
							}else{
								oSB.addClass('change');
							}
						}else{
							oKS.addClass('change');
							oSB.addClass('change');
						}
                    });
					oSB.change(function(e) {
						var vSB = parseInt($(this).val(),10); // [細別] の選択肢を更新
                        obj.find(".sb").text(vSB);
						if( v['sb_id'] == vSB ){
							oSB.removeClass('change');
						}else{
							oSB.addClass('change');
						}
                    });
				}
			}
		});
	}
}
function showDetailN(tg){ // 入金詳細編集用 ... tg:表示位置の基準　id:実施明細のid
	var id = tg.attr('data-id');
	var obj = $("#jdetailbox");
	obj.html( tmp_jDetail ).show();
	var stat = ( id===undefined ) ? 'new' : 'update';
	var isNewWin = ( id===undefined ) ? true : false;
	obj.find("table").addClass(stat);
	obj.find("input.date").datepicker();
	if( isNewWin ) obj.find('tfoot div.del').hide(); // 新規の時、[削除]は消す
	var x = tg.offset().left + tg.outerWidth(true) - obj.outerWidth(true);
	var y = tg.offset().top + tg.outerHeight(true);
	obj.css({left:x, top:y});
	// --- event ---
	obj.find("input.fld")
		.keyup(function(e) {
			var c = e.which ? e.which : e.keyCode;
			var na = $(this).attr('name');
			if( c==13 ){
				switch(na){
					case 'dat': $('#jdetailbox input[name="kou"]').focus(); break;
					case 'kou': $('#jdetailbox input[name="kin"]').focus(); break;
					case 'kin': $('#jdetailbox input[name="dat"]').focus(); break;
				}
			}
		})
		.focus(function(e) { eventFocus($(this), !isNewWin); })
		.blur(function(e)  { eventBlur($(this), !isNewWin); });
	obj.find(".close_btn")
		.click(function(e) { hidePopup(); });
	obj.find('button.post')
		.click(function(e) {
			var mainid = $("#hdr_id .id").text();
			var vDat = obj.find("input.fdat").val();
			var vKou = obj.find("input.fkou").val();
			var vKin = cInt(obj.find("input.fkin").val());
			if( isNewWin ){
				var d = { 'mainid':mainid, 'ks_id':0, 'sb_id':0, 'ku':2, 'jyun':0, 'date':vDat, 'koumoku':vKou, 'kin':vKin };
				var data = JSON.stringify(d);
				asyncPost('job=meisai_add&data='+data, function(e){
					recalcN(mainid);
					hidePopup(); // 詳細・一覧両方を閉じる
				});
			}else{
				if( obj.find('input.del').prop('checked') ){ // 削除する場合
					if( confirm(jstr(31)) ){
						asyncPost('job=meisai_del&id='+id, function(e){
							if( e=='ok' ){
								recalcN(mainid); // 再計算・再表示
								hidePopup(); // 詳細・一覧両方を閉じる
							}else{
								alert(jstr(32));
								hidePopup();
							}
						});
					}
				}else{
					if( obj.find('input.change').length > 0 ){ // 変更箇所があれば
						var d = { 'date':vDat, 'koumoku':vKou, 'kin':vKin };
						var data = JSON.stringify(d);
						asyncPost('job=meisai_update&id='+id+'&data='+data, function(e){
							recalcN(mainid);
							hidePopup();
						});
					}else{
						hidePopup();
					}
				}
			}
    	});
	// --- data表示 ---
	if( isNewWin ){
		obj.find("caption").text(jstr(36));
		obj.find("button.post").text(jstr(34));
		obj.find(".id").text( $("#hdr_id .id").text() ); /* 工事id */
		obj.find("input.fdat").focus();
	}else{
		obj.find("caption").text(jstr(37));
		obj.find("button.post").text(jstr(21));
		asyncPost('job=jdetail&id='+id, function(e){
			if( isJSON(e) ){
				var v = JSON.parse(e);
				obj.find(".id").text(id); /* 明細id */
				obj.find("input.fdat").val(v['date']).attr({'data-def':v['date']}).focus();
				obj.find("input.fkou").val(v['koumoku']).attr({'data-def':v['koumoku']});
				obj.find("input.fkin").attr({'data-def':v['kin']});
				setValueNum(obj.find("input.fkin"), v['kin']);
			}
		});
	}
}
function showBtnKoumokuSelect(tg, data){ // 選択肢表示用のボタンの表示/非表示
	var btn = $("#listboxButton");
	if(tg===undefined){
		btn.attr({'data-name':''}).hide();
	}else{
		var html = '<img src="/-/module/pskk/images/down12.png">';
		btn.html(html);
		var x = tg.offset().left + tg.outerWidth() - 13;
		var y = tg.offset().top + 3;
		btn.css({top:y, left:x}).attr({'data-name':tg.attr('name')}).show();
	}
}
function showListKoji(){ // [工事一覧] の表示
	var obj = $("#pskk_contents");
	var ymd = obj.attr('data-start');
	var ki = obj.attr('data-ki');
	obj.html( tmp_list ); // 不変部分を表示
	obj.find('span.now_ki').text(ki); // タイトルの [期] を表示
	$("#pskk_select_ki span").html( select_ki(ymd, ki) ); // [期] の選択肢を表示
	// 設定画面の定義
	var opt = $("#pskk_options_area"); // [システム詳細設定] 画面内の設定
	opt.html( tmp_options )
		.dialog({
			width:400, modal:true, title:jstr(38), autoOpen:false, resizable:false,
			position:{my:"right top", at:"right bottom", of:$("#pskk_options") },
			open: function(){ // 開いた時 ... テーブル etc の情報を表示
				asyncPost('job=etc', function(e){
					if( isJSON(e) ){
						var p = JSON.parse(e);
						opt.find('[name^="etc_"]').each(function(index, element) {
                            if( $(this).attr('name').match(/^etc_(.*)$/) ){
								if(p[RegExp.$1]!==undefined) $(this).val( p[RegExp.$1] );
							}
                        });
					}else{
						alert(e);
					}
				});
			},
			buttons:{
				'保存': function(){
					var v = {};
					opt.find('[name^="etc_"]').each(function(index, element) {
						if( $(element).attr('name').match(/^etc_(.*)$/) ){
							v[RegExp.$1] = $(this).val();
						}
					});
					syncPost('job=etc_update&data='+JSON.stringify(v), function(e){
						if( e==='ok' ){
							opt.dialog("close");
							showListKoji();
						}else{
							alert(e);
						}
					});
				},
				'キャンセル': function(){ opt.dialog("close");}
			}
		});
	$("#add_koji").button();	// [新規工事]ボタン のUI定義
	$("#pskk_options")			// [システム詳細設定]ボタン のUI定義、クリック時
		.button({ icons:{ primary:'ui-icon-gear' }, text:false})
		.click(function(e) { opt.dialog("open");});
	$('#to_site')
		.button({ icons:{ primary:'ui-icon-home' }, text:false })
		.click(function(e) { window.location.href = '/'; });
	// データ一覧表示
	$("#pskk_list tbody").html('<tr><td colspan=8><center>Loading ...</center></td></tr>'); // Loading ... 表示
	asyncPost('job=list&ymd_start='+ymd+'&nendo='+ki, function(e){
		var html = '',
			total = [0,0,0,0,0,0,0,0],
			rows = 0;
		if( isJSON(e) ){
			var p = JSON.parse(e),
				data   = p['data'],
				dbInfo = p['info'],
				fields = 'id,name,kin1,tanto,gst_name,date1,arari,p3'.split(','),	// 一覧の列名
				cls    = 'key,txt,cur,txt,txt,date,cur,per'.split(',');				// 各列の属性
			rows = data.length;
			if( rows>0 ){
				$.each( data, function(index, v){
					var status = (v.status==null) ? {} : JSON.parse(v.status),
						kjEnd  = status.end===undefined ? 0 : status.end;
					html += '<tr data-id="'+v['id']+'" data-end="'+kjEnd+'">';
					for(var i=0; i<fields.length; i++){
						var c = 'c'+i+' '+cls[i]; c += (i==0) ? ' cl' : ' cm';
						var cap = v[ fields[i] ];
						if( cls[i]=='cur' || cls[i]=='per' ){
							total[i] += cap;
							if( parseInt(cap)<0 ){ c += ' minus';}
							cap = ccur(cap);
						}
						html += '<td class="'+c+'"><div>'+cap+'</div></td>';
					}
					html += '</tr>';
				});
			}else{
				html = '<tr><td colspan=8><center>'+jstr('no data')+'</center></td></tr>';
			}
		}else{
			html = '<tr><td colspan=8><center>'+jstr('no data')+'</center></td></tr>';
			var dbInfo = [];
		}
		$("#pskk_list tbody").html(html);
		// App バージョン
		var v = $("#pskk_contents").attr('data-appver');
		var appVer = parseInt(v,10);
		var appVerDb = (dbInfo['appver']===undefined) ? 0 : parseInt(dbInfo['appver'],10);
		if( appVerDb < appVer ){ // db が古い場合、db チェック
			syncPost('job=newver&appver='+appVer, function(e){
				$("#pskk_caution").text(e).addClass('caution');
			});
		}else{ $("#pskk_caution").text('').removeClass('caution');}
		// 総合計行の表示
		if( rows == 0 ){
			$("#pskk_list tfoot td.c2").text('');
			$("#pskk_list tfoot td.c6").text('');
			$("#pskk_list tfoot td.c7").text('');
		}else{
			$("#pskk_list tfoot td.c2").text( ccur(total[2]) );
			$("#pskk_list tfoot td.c6").text( ccur(total[6]) );
			$("#pskk_list tfoot td.c7").text( parseInt(total[7] / rows) );
		}
		// Pager の定義
		$("#pskk_list").psPager({ perPage:false, rowsPerPage:50 });
		var tg = $("#pskk_list thead");
		var pg = $("#psPager");
		var xx = tg.offset().left + tg.outerWidth() - pg.outerWidth();
		var yy = tg.offset().top - pg.outerHeight() - 3;
		pg.css({'left':xx, 'top':yy});
		// 一覧フッタ
		var info = JSON.stringify(dbInfo);
		var txt = '<div class="cname">'+$("#pskk_contents").attr('data-name')+'</div>'
				+ '<div class="fstat">'+dbInfo['dbn']+' | '+dbInfo['lastupdate']+'</div>';
		$("#pskk_list_ftr").html(txt);
		// ============= event ==============
		// 期間を変更した場合
		$("#pskk_select_ki").on('change', '#nendo', function(index, element){
			var ki = $(this).val();
			$("#pskk_contents").attr({'data-ki':ki});
			$("#pskk_contents .now_ki").text(ki);
			showListKoji();
		});
		// 工事一覧の行をクリックした場合
		$("#pskk_list tbody tr").click(function(e) {
			var id = $(this).attr('data-id');
			if(id!==undefined) showDetail(id);
		});
		//
		$("#add_koji").click(function(e) {
			showDetail();
		});
	});

}
function select_ki(ymd, ki){
	var fki = 1;
	syncPost('job=etc', function(e){
		if( isJSON(e) ){
			var p = JSON.parse(e);
			if(p['viewaddki']!==undefined) fki = parseInt(p['viewaddki']);
		}
	});
	var su = age(ymd) + fki;	// 選択肢の数 ... 初年度から翌年度まで
	var ymd0 = new Date();	// 現在の年月日
	var ymd1 = new Date(ymd);	// 初年度開始の年月日
	var md1 = padZero(ymd1.getMonth()+1)+'-'+padZero(ymd1.getDate());	// 開始年月
	var items = '';
	for(var i = su; i>0; i--){
		var y = ymd0.getFullYear() - (su-i) - 1;
		var ymdST  = new Date(y+'-'+md1);
		var ymdED  = new Date(''+(y+1)+'-'+md1); ymdED.setDate(ymdED.getDate() - 1);
		var ymdSTs = ""+(ymdST.getFullYear()+1)+'-'+padZero(ymdST.getMonth()+1)+'-'+padZero(ymdST.getDate());
		var ymdEDs = ""+(ymdED.getFullYear()+1)+'-'+padZero(ymdED.getMonth()+1)+'-'+padZero(ymdED.getDate());
		var sel = ( i==ki ) ? ' selected' : '';
		items += "<option value=\""+i+"\""+sel+">"+jstr(5)+" "+i+" "+jstr(41)+" ("+ymdSTs+' '+jstr(42)+' '+ymdEDs+")</option>";
	}
	return '<select id="nendo">'+items+'</select>';
}
function showListY(obj){ // 選択リストのポップアップ表示
	var list = $("#listbox");
	var id = $("#hdr_id .id").text();
	if( obj.hasClass('btn') ){ // obj = btn なら
		var key = obj.attr('data-name'); // リスト表示ボタン(obj)の data-name から fld
		var fld = $('#pskk_detail input[name='+key+']');
		var fpr = fld;
	}else{
		var key = obj.attr('name'); // リスト表示ボタン(obj)の
		var fld = obj;
		var fpr = obj;
		
	}
	if(key.match(/^hdr_([a-zA-Z0-9\_]+)/)){ // ヘッダ項目の場合
		var job = "job=sel_hdr&id="+id+"&ks="+RegExp.$1;
	}else if(key.match(/^m_c1_([0-9]+)_([0-9]+)/)){	// 予定 項目名 の場合
		var job = "job=sel_mei&ks="+RegExp.$1+"&sb="+RegExp.$2;
	}
	asyncPost(job, function(e){
		if( isJSON(e) ){
			var dt = JSON.parse(e);
			var html = "<ul>";
			for(var i=0; i<dt.length; i++){
				html += "<li>"+dt[i]['name']+"</li>";
			}
			html += "</ul>";
			list.html(html);
			setClass(list, 'balloon', 'balloon-b');
			// 一覧アイテムをクリック
			$("#listbox li").click(function(e) {
				var v = $(this).text();
				fld.val(v);
				list.hide();
				fld.focus();
			});
		}else{
			list.html('<ul><li>'+showMessage(e)+'</li></ul>');
			setClass(list, 'balloon', 'balloon-b');
		}
	});
	var x = fpr.offset().left - 3;
	var y = fpr.offset().top + fpr.outerHeight();
	list.css({'position':'absolute', 'left':x, 'top':y, 'z-index':9999});
	list.removeClass('hide').addClass('show');
	list.show();
}
function showListJ(obj){ // 実施項目内訳の表示（実施細別選択時）
	var key = obj.attr('name');
	if( key.match(/^m_c([34])_([0-9]+)_([0-9]+)$/) ){ // 実施 項目名・金額 の場合
		var mainid  = $("#hdr_id .id").text();
		var ks = RegExp.$2;
		var sb = RegExp.$3;
		asyncPost("job=sel_mj&id="+mainid+"&ks="+ks+"&sb="+sb, function(e){
			var list = $("#listbox");
			var html = '<div class="fbtn close_btn">'+jstr(39)+'</div>';
			if(isJSON(e)){
				var dt = JSON.parse(e);
				html += '<div class="fbtn add_btn">'+jstr(40)+'</div><ul>';
				for(var i=0; i<dt.length; i++) html += '<li data-id="'+dt[i]['id']+'">'+dt[i]['name']+"</li>";
				html += "</ul>";
				list.html(html);
				setClass(list, 'balloon', 'balloon-r');
				list.find("input.date").datepicker();
				// 各フィールドの幅を調整
				$("#listbox input.fld").each(function(index, element) {
					var w = $(this).parent('td').attr('width');
					$(this).css({'width':w});
				});
				// --- event ---
				$("#listbox li").click(function(e) {
					$("#listbox li.selected").removeClass('selected');
					$(this).addClass('selected');
					showDetailJ( tg, $(this).attr('data-id') );
				});
			}else{
				html += '<div class="fbtn add_btn">'+jstr(40)+'</div>';
				html += '<div class="err2">'+showMessage(e)+'</div>';
				list.html(html);
				setClass(list, 'balloon', '');
			}
			// 表示位置
			var tg = $('#main_list input[name="m_c4_'+ks+'_'+sb+'"]');
			var tgp = tg.parent();
			var x = tgp.offset().left + tgp.outerWidth(true);
			var y = tgp.offset().top - 18;
			list.css({'position':'absolute', 'left':x, 'top':y, 'z-index':9999});
			list.removeClass('hide').addClass('show');
			list.show();
			// --- event ---
			$("#listbox .close_btn").click(function(e) { hidePopup(); });
			$("#listbox .add_btn").click(function(e) { showDetailJ(tg); });
		});
	}
}
function showListJAll(id){ // 実施明細一覧（tab2内）
	var obj = $("#ku1_list");
	obj.html( tmp_jlist_all );
	asyncPost('job=ku1&id='+id, function(e){
		if( isJSON(e) ){
			var m = JSON.parse(e);
			var html = '';
			for(var i=0; i<m.length; i++){
				var v = parseInt(m[i]['kin']);
				var c = ( v<0 ) ? ' minus' : '';
				var o = $('#main_list input[name="m_c0_'+m[i]['ks_id']+'_'+m[i]['sb_id']+'"]');
				var ks = o.attr('data-ksname');
				var sb = o.val();
				html += "<tr data-id="+m[i]['id']+">"
					+'<td class="dat">'+cSp(m[i]['date'])+"</td>"
					+'<td class="kou">'+cSp(m[i]['koumoku'])+"</td>"
					+'<td class="kin'+c+'">'+ccur(v)+"</td>"
					+'<td class="ksn" data="'+m[i]['ks_id']+'">'+ks+"</td>"
					+'<td class="sbn" data="'+m[i]['sb_id']+'">'+sb+"</td>"
					+"</tr>";
			}
			obj.find('tbody').html(html);
			// --- event --- 実施明細の各行をクリック  
			$("#ku1_list td").click(function(e) {
				var trp = $(this).parent();
				var jid = trp.attr('data-id');
				trp.parent().find('tr').removeClass('act');
				trp.addClass('act');
				showDetailJ( trp, jid, 1);
			});
		}else{
			obj.find('tbody').html('<tr><td colspan=6><center>'+jstr(19)+'</center></td></tr>');
		}
	});
}
function setValueNum(obj, data){ // input の value に数値を表示
	if( obj.hasClass('per') ){ // -------------------- per ... パーセント
		if( data<0 ){
			obj.val(data+'%').addClass('minus');
		}else{
			obj.val(data+'%').removeClass('minus');
		}
	}else if( obj.hasClass('cur') ){ // -------------- cur ... 通貨
		if( data==0 ){
			obj.val('');
		}else if( data<0 ){
			obj.val( ccur(data) ).addClass('minus');
		}else{
			obj.val( ccur(data) ).removeClass('minus');
		}
	}else if( obj.hasClass('chk') ){ // -------------- chk
		if(data==1){
			obj.prop({'checked': 'checked'});
		}else{
			obj.prop({'checked': ''});
		}
	}else{											// それ以外
		var v = new String(data);	// 文字列に変換しないと、split でエラーになる
		v.split("[CR]").join("\n");
		obj.val(v);
	}
}
function setInt(obj, val, def){ // input の value に数値を表示 (数値専用)
	var v = parseInt(val,10);
	if( v==0 ){
		obj.val('');
	}else if( v<0 ){
		obj.val( ccur(v) ).addClass('minus');
	}else{
		obj.val( ccur(v) ).removeClass('minus');
	}
	if( def===1 ) obj.attr({'data-def':v});
}
// 汎用
function setClass(obj, removeName, addName){ // 先頭一致で関連のクラス名を削除して、新しいクラス名を追加
	var d = obj.attr('class').split(' ');
	for(var i=0; i<d.length; i++){
		if(d[i].substr(0, removeName.length)==removeName){
			obj.removeClass(d[i]);
		}
	}
	obj.addClass(addName);
}
function syncPost(jobStr, jobFunc, errFunc){ // 同期 POST
	var addJob = function(na){
			var v = $("#pskk_contents").attr('data-'+na);
			return ( v!==undefined ) ? '&'+na+'='+v : '&'+na+'=';
		},
		s = addJob('sub')+addJob('uid')+addJob('uml')+addJob('dbn');
	$.ajax({
		data:jobStr+s,
		url: "/wp-content/plugins/pskk/psh_v2.php", type:"POST", async:false, cache:false,
		error: function(e){ if( $.isFunction(errFunc) ){ errFunc(e);}else{ alert(e.statusText);} },
		success: function(e , tp){ jobFunc(e); }
	});
}
function asyncPost(jobStr, jobFunc, errFunc){ // 非同期 POST
	var addJob = function(na){
			var v = $("#pskk_contents").attr('data-'+na);
			return ( v!==undefined ) ? '&'+na+'='+v : '&'+na+'=';
		},
		s = addJob('sub')+addJob('uid')+addJob('uml')+addJob('dbn');
	$.ajax({
		data:jobStr+s,
		url: "/wp-content/plugins/pskk/psh_v2.php",
		type:"POST", async:true, cache:false,
		error: function(e){ if( $.isFunction(errFunc) ){ errFunc(e);}else{ alert(e.statusText);} },
		success: function(e , tp){
			// console.log(e); // ************
			jobFunc(e);
		}
	});
}
function sysLogin(jobStr, jobFunc, errFunc){
	$.ajax({
		data:jobStr, url: "/-/sys/psh_site.php", type:"POST", async:false, cache:false,
		error: function(e){ if( $.isFunction(errFunc) ){ errFunc(e);}else{ alert(e.statusText);} },
		success: function(e , tp){ jobFunc(e); }
	});
}
function recalcJ(mainid, ks, sb){ // １か所の実施明細と関連合計を再計算
	//
	var job = 'job=j1&mainid='+mainid+'&ks='+ks+'&sb='+sb;
	asyncPost(job, function(e){
		if( isJSON(e) ){
			var p = JSON.parse(e);
			var t = cDateYM(p[0]['date'])+' '+p[0]['koumoku'];
			var g = 0; for(var i=0; i<p.length; i++){ g += p[i]['kin'];}
			var obj = $("#main_list");
			obj.find('input[name="m_c3_'+ks+'_'+sb+'"]').val(t);
			setValueNum(obj.find('input[name="m_c4_'+ks+'_'+sb+'"]'), g);
			recalc(1, ks);
			checkChangeAll();
		}else{
			var err = (e.split(':'))[1];
			switch(err){
				case 'no data': // 削除して明細がなくなった場合 (pshからはエラーで返ってくる)
					var obj = $("#main_list");
					obj.find('input[name="m_c3_'+ks+'_'+sb+'"]').val('');
					obj.find('input[name="m_c4_'+ks+'_'+sb+'"]').val('');
					recalc(1, ks);
					checkChangeAll();
					break;
				case 'session timeout': alert(jstr(18)); break;
				default: alert(err); break;
			}
		}
	});
}
function recalcN(mainid){ // 入金明細を再表示・再計算
	asyncPost('job=nyukin&mainid='+mainid, function(e){
		$("#nyukin_meisai input").val('').attr({'data-id':''}); // 入金明細を一旦消す
		if( isJSON(e) ){
			var p = JSON.parse(e);
			var total = 0;
			// 入金明細表示
			for(var i=0; i<p.length; i++){
				var obj = $("#nyukin_meisai");
				var f1 = obj.find('input[name="nd_'+i+'"]');
				var f2 = obj.find('input[name="nk_'+i+'"]');
				f1.val( cDateYM(p[i]['date']) ); // 日付
				setValueNum( f2, p[i]['kin']);   // 金額
				total += p[i]['kin'];
				f1.attr({'data-id':p[i]['id'], 'title':p[i]['koumoku']});
				f2.attr({'data-id':p[i]['id'], 'title':p[i]['koumoku']});
			}
		}
		recalc(2);
		checkChangeAll();
	});
}
function recalc(pos, ks){ // 再計算
	var _per1 = function(){ // 総工事費率 ... 予定額合計 ÷ 契約金額(税込) × 100
		var n1 = _toNum( $('#main_list input[name="hdr_g1"]').val() );
		var n2 = _toNum( $('#pskk_detail input[name="hdr_kin1"]').val() );
		var objP1 = $('#pskk_detail input[name="hdr_p1"]');
		var v = (n2==0) ? 0 : Math.round( n1 / n2 * 100 );
		setValueNum( objP1, v);
		if( objP1.attr('data-def')!=v ){ objP1.addClass('change'); }else{ objP1.removeClass('change');}
	}
	var _per2 = function(){ // 支払比率 ... 実施額合計 ÷ 契約金額(税込) × 100
		var n1 = _toNum( $('#main_list input[name="hdr_g2"]').val() );
		var n2 = _toNum( $('#pskk_detail input[name="hdr_kin1"]').val() );
		var objP2 = $('#pskk_detail input[name="hdr_p2"]');
		var v = (n2==0) ? 0 : Math.round( n1 / n2 * 100 );
		setValueNum( objP2, v);
		if( objP2.attr('data-def')!=v ){ objP2.addClass('change'); }else{ objP2.removeClass('change');}
	}
	var _arari = function(){ // 粗利率 ... 100 - 支払比率
		var objP3 = $('#pskk_detail input[name="hdr_p3"]');
		var n1 = _toNum( $('#pskk_detail input[name="hdr_p2"]').val() );
		var v = 100 - n1;
		setValueNum( objP3, v);
		if( objP3.attr('data-def')!=v ){ objP3.addClass('change'); }else{ objP3.removeClass('change');}
	}
	var _yj = function(p1, p2, ks){ // 指定した 工事種別(ks) の予定金額(p1)を合計して、合計欄(p2)に表示
		var g = 0;
		$('#main_list input[name^="m_'+p1+'_'+ks+'_"]').each(function(index, element) { g += _toNum( $(this).val() ); });
		setValueNum($('#main_list input[name="total_'+p2+'_'+ks+'"]'), g);
	}
	var _toNum = function(data){
		if(data===undefined) return 0;
		var s = data.replace(/[^\d\-]/g,'');
		return ( s=='' ) ? 0 : parseInt(s);
	}
	switch(pos){
		case 0: // 予定
			_yj('c2','y', ks);
			// 予定の総合計
			var g = 0; $('#main_list input[name^="total_y_"]').each(function(index, element) { g += _toNum( $(this).val() ); });
			var o = $('#main_list input[name="hdr_g1"]'); setValueNum(o, g); _per1();
			break;
		case 1: // 実施
			_yj('c4','j', ks);
			var g = 0; $('#main_list input[name^="total_j_"]').each(function(index, element) { g += _toNum( $(this).val() ); });
			var o = $('#main_list input[name="hdr_g2"]'); setValueNum(o, g); _per2(); _arari();
			break;
		case 2: // 入金
			var g = 0;
			$('#nyukin_meisai input[name^="nk_"]').each(function(index, element) { g += _toNum( $(this).val() ); });
			var o = $('#nyukin_meisai input[name="hdr_g3"]'); setValueNum(o, g); _per2(); _arari();
			break;
		case 3: // 契約金額(税別)の変更
			var p0 = _toNum( $('#pskk_detail input[name="hdr_kin0"]').val() );
			var tax = _toNum( $('#tab_contents_etc input[name="hdr_taxp"]').val() );
			var o = $('#pskk_detail input[name="hdr_kin1"]');
			var g = Math.round( p0 * (tax+100) / 100); setValueNum(o, g); _per1(); _per2(); _arari();
			break;
	}
	if( o.attr('data-def')!=g ){ o.addClass('change'); }else{ o.removeClass('change');}
	//checkChangeAll();
}
function hidePopup(){ // ポップアップ画面をすべて閉じる
	var tn = parseInt($("#pskk_tabs").attr('data-index'),10);
	switch(tn){
		case 0:
			$("#main_list input.selected").removeClass('selected');
			$("#nyukin_meisai input.selected").removeClass('selected');
			break;
		case 1:
			$("#ku1_list").find("tr.act").removeClass('act');
			break;
	}
	$("#listbox").html('').hide().removeClass('show').addClass('hide');
	$("#jdetailbox").html('').hide();
}
function postData(){ // 未保存データを一括で更新
	var obj = $("#pskk_detail");
	var isNew = obj.hasClass('new') ? true : false;
	// 更新対象
	if( isNew ){ // 新規の場合
		var objFld = obj.find('input.fld, textarea.fld'); // 全ての .fld が対象
	}else{		// 更新の場合
		var objFld = obj.find('input.change, textarea.change'); // 変更箇所のみが対象
	}
	var cngHdr = parseInt(obj.attr('data-change-hdr'),10);
	var cngMei = parseInt(obj.attr('data-change-mei'),10);
	// 計画書データ
	var h = {}, // ---- main 用（実フィールドがあるもの）
		h2 = {}, // --- main 用 ... 実フィールドのないものを status にまとめる
		d = {};
	objFld.each(function(index, element) {
		var key = $(element).attr('name');
		var val = $(element).val();
		if( key.match(/^hdr_(.*)$/) ){ // main テーブル用のデータ
			var key = RegExp.$1;
			switch(key){
				default: var v = val; break;
				case 'kin0':
				case 'kin1':
				case 'g1':
				case 'g2':
				case 'g3':
				case 'p1':
				case 'p2':
				case 'p3': var v = cInt(val); break;
				case 'end': h2[key] = $(element).prop('checked') ? 1 : 0; break;
			}
			h[key] = v;
		}else if( key.match(/^m_c([0-2])_([0-9]+)_([0-9]+)$/) ){ // sub 用のデータ
			var pos = parseInt(RegExp.$1,10);
			var ks_id = parseInt(RegExp.$2,10);
			var sb_id = parseInt(RegExp.$3,10);
			var key = ks_id+'_'+sb_id;
			switch(pos){
				case 0: var f = 'sb_name'; var v = val; break;
				case 1: var f = 'koumoku'; var v = val; break;
				case 2: var f = 'kin'; var v = cInt(val); break;
			}
			if( d[key]===undefined ) d[key] = {};
			d[key][f] = v;
		}
	});
	// データ更新
	var data = JSON.stringify({'hdr':h, 'hdr2':h2, 'mei':d});
	var id = $("#hdr_id .id").text();
	asyncPost('job=update&id='+id+'&data='+data, function(e){
		if( e=='ok' ){
			showListKoji();
		}else{
			alert(e);
		}
	});
}
function isJSON(arg){
	arg = (typeof arg === "function") ? arg() : arg;
	if (typeof arg  !== "string") { return false;}
	try{
		arg = (!JSON) ? eval("(" + arg + ")") : JSON.parse(arg);
		return true;
	}catch(e){
		return false;
	}
}
function isDate(value, userFormat){
    userFormat = userFormat || 'yyyy-mm-dd'; // フォーマットがない場合はデフォルトのフォーマットをセットする
    var delimiter = /[^ymd]/.exec(userFormat)[0]; // y m d 以外の文字を取り出す。その最初の文字が区切り文字
    var theFormat = userFormat.split(delimiter);  // フォーマットを、年月日に分割
    var theDate   = value.split(delimiter);       // 指定文字列を、年月日に分割
    var _chk = function(date, format) {
        var y, m, d, v;
        for(var i=0; i<format.length; i++) {
            v = format[i];
            if (/m/.test(v)) m = date[i]; // .test(v) ... v に m が含まれているかを調べる
            if (/d/.test(v)) d = date[i];
            if (/y/.test(v)) y = date[i];
        }
        return ( y && y.length===4 && m>0 && m<13 && d>0 && d<=(new Date(y, m, 0)).getDate() );
    }
    return _chk(theDate, theFormat);	
}
function ccur(data){ return String(data).replace(/(\d)(?=(\d\d\d)+(?!\d))/g, '$1,');}
function cInt(data){ var s = data.replace(/[^0-9\-]/g, ''); return (s=='') ? 0 : parseInt(s);}
function cSp(dat){ return (dat=="") ? '&nbsp;' : dat;}
function padZero(int){ if( int<10 ) int = "0"+int; return ""+int;}
function age(ymd){
	var p = ymd.split('-');
	var d1 = parseInt(""+p[0]+p[1]+p[2]);
	var d = new Date();
	var d0 = parseInt(""+d.getFullYear()+padZero(d.getMonth()+1)+padZero(d.getDate()));
	return parseInt((d0 - d1)/10000) + 1;
}
function cDateYM(ymd){
	if( ymd.match(/^(\d+)-(\d+)-(\d+)$/) ){
		var d1 = new Date(ymd);	// 開始日
		return padZero(d1.getMonth()+1)+'/'+padZero(d1.getDate());
	}else{ return '';}
}
