/*
	v2_tmp.js ... v2用テンプレート --
	
	※ inc:dev:jsmin の「2:標準」でスリム化後、http://dean.edwards.name/packer/ で Base62 encode でパック！
*/
function jstr(no){
	function s2(){
		var ht = "", nu;
		for(var i=0; i<s2.arguments.length; i++){
			nu = 12350 + s2.arguments[i];
			ht += String.fromCharCode(nu);
		}
		return ht;
	}
	switch(no){
		default: var ret = no; break;
		case 0: // この「工事管理システム」は、許可されたユーザーでのログインが必要です。
			var ret = s2(21,48,-50,11687,7757,19299,17352,121,123,136,162,-49,49,-61,23027,9137,23,78,33,168,190,120,190,41,48,175,114,102,181,14,12167,22851,41,27,-60); break;
		case 1: // ユーザー名：
			var ret = s2(168,190,120,190,9167,52956); break;
		case 2: // パスワード：
			var ret = s2(147,123,177,190,139,52956); break;
		case 3: // 次回から自動ログイン
			var ret = s2(15075,9888,13,75,20908,8855,175,114,102,181); break;
		case 4: // ログイン
			var ret = s2(175,114,102,181); break;
		case 5: // 第
			var ret = s2(19182); break;
		case 6: // 期 工事一覧
			var ret = s2(14049,-12318,11687,7757,7618,22889); break;
		case 7: // 期間：
			var ret = s2(14049,25941,52956); break;
		case 8: // 新規工事
			var ret = s2(13682,22865,11687,7757); break;
		case 9: // 合計
			var ret = s2(9162,22986); break;
		case 10: // 総合計
			var ret = s2(19857,9162,22986); break;
		case 11: // 工事名
			var ret = s2(11687,7757,9167); break;
		case 12: // 受注金額
			var ret = s2(9113,15530,24979,26639); break;
		case 13: // 担当者
			var ret = s2(12935,12053,20423); break;
		case 14: // 発注元名
			var ret = s2(17980,15530,8453,9167); break;
		case 15: // 工期(自)
			var ret = s2(11687,14049,-12310,20908,-12309); break;
		case 16: // 粗利額
			var ret = s2(19545,8683,26639); break;
		case 17: // 粗利率
			var ret = s2(19545,8683,17225); break;
		case 18: case 'session timeout': // 一定時間通信が無かったため<wbr>接続を中断しています。<wbr>F5 を押して再読み込みをしてください。
			var ret = s2(7618,11100,13828,25941,24540,8099,14,16611,13,37,33,33,67,-12290,-12231,-12252,-12236,-12288,13159,19804,84,7663,13679,25,40,6,64,27,-60,-12290,-12231,-12252,-12236,-12288,-12280,-12297,-12318,84,12926,25,40,8527,23151,65,24446,65,84,25,40,17,34,23,6,-60); break;
		case 19: case 'no data': // データがありません.
			var ret = s2(137,190,129,14,4,76,64,29,85,-12304); break;
		case 20: // 工事計画書
			var ret = s2(11687,7757,22986,17661,14010); break;
		case 21: // 更新
			var ret = s2(14006,13682); break;
		case 22: // 一覧へ戻る
			var ret = s2(7618,22889,58,12797,77); break;
		case 23: // 契約先
			var ret = s2(10515,19654,8458); break;
		case 24: // 保存していないデータは無効になります。
			var ret = s2(8095,11034,25,40,6,44,6,137,190,129,49,16611,8827,45,44,76,64,27,-60); break;
		case 25: case 'cant_login': // ログインできません。
			var ret = s2(175,114,102,181,41,15,64,29,85,-60); break;
		case 26: case 'att_change': // 変更箇所があります。違うページへ移動すると変更が無効になります。移動しますか？
			var ret = s2(10443,14006,19273,12802,14,4,76,64,27,-60,24599,8,156,190,122,58,18877,8855,27,77,42,10443,14006,14,16611,8827,45,44,76,64,27,-60,18877,8855,25,64,27,13,52961); break;
		case 27: // 変更箇所：
			var ret = s2(10443,14006,19273,12802,52956); break;
		case 28: case 'no_koki_ed': // 伝票を完了するには、少なくとも「工期(至)」は正しい日付である必要があります。
			var ret = s2(7903,18730,84,11086,7752,27,77,45,49,-61,11219,44,17,42,68,-50,11687,14049,-12310,20917,-12309,-49,49,15141,25,6,13735,7834,41,4,77,12167,22851,14,4,76,64,27,-60); break;
		case 29: case 'delkoji': // この工事に関する全データを削除します。よろしいですか？
			var ret = s2(21,48,11687,7757,45,25956,27,77,8490,137,190,129,84,8716,26150,25,64,27,-60,74,79,25,6,41,27,13,52961); break;
		case 30: case 'new': // 登録
			var ret = s2(17981,25332); break;
		case 31: // この明細を削除します。よろしいですか？
			var ret = s2(21,48,13776,19698,84,8716,26150,25,64,27,-60,74,79,25,6,41,27,13,52961); break;
		case 32: case 'cant_del': // 実施明細を削除できませんでした。
			var ret = s2(11105,13695,13776,19698,84,8716,26150,41,15,64,29,85,41,25,33,-60); break;
		case 33: // 実施明細追加
			var ret = s2(11105,13695,13776,19698,24511,8802); break;
		case 34: // 新規追加
			var ret = s2(13682,22865,24511,8802); break;
		case 35: // 実施明細変更
			var ret = s2(11105,13695,13776,19698,10443,14006); break;
		case 36: // 入金明細追加
			var ret = s2(8487,24979,13776,19698,24511,8802); break;
		case 37: // 入金明細変更
			var ret = s2(8487,24979,13776,19698,10443,14006); break;
		case 38: // 設定
			var ret = s2(23023,11100); break;
		case 39: // ×
			var ret = s2(-12135); break;
		case 40: // ＋
			var ret = s2(52941); break;
		case 41: // 期
			var ret = s2(14049); break;
		case 42: // ～
			var ret = s2(53024); break;
		case 43: // 変更箇所があります。一覧へ移動する前に保存してください。
			var ret = s2(10443,14006,19273,12802,14,4,76,64,27,-60,7618,22889,58,18877,8855,27,77,8719,45,8095,11034,25,40,17,34,23,6,-60); break;
		case 44: // 変更箇所があります
			var ret = s2(10443,14006,19273,12802,14,4,76,64,27); break;
		case 45: case 'save': // 保存
			var ret = s2(8095,11034);; break;
/*
		case : // 
			var ret = ; break;
*/
	}
	return ret;
}

var tmp_login = '<table class="login">'
	+'<caption><h3>'+jstr(4)+'</h3></caption>'
	+'<thead>'
		+'<tr><td colspan="2"><center>'+jstr(0)+'</center></td></tr>'
	+'</thead>'
	+'<tbody>'
		+'<tr><th>'+jstr(1)+'</th><td><input type="email" name="uid"></td></tr>'
		+'<tr><th>'+jstr(2)+'</th><td><input type="password" name="upw"></td></tr>'
		+'<tr><td></td><td><input type="checkbox" name="c1" id="c1" value="1" checked><label for="c1">'+jstr(3)+'</label></td></tr>'
	+'</tbody>'
	+'<tfoot>'
		+'<tr><td></td><td><button class="submit">'+jstr(4)+'</button></td></tr>'
	+'</tfoot>'
	+'</table>';


var tmp_logout = '<table class="login">'
	+'<tr><td>'
		+'ログイン中のユーザーは、このシステムの利用を許可されていません。<br>'
		+'許可されているユーザーでログインし直して下さい。<br><br>'
		+'<button>戻る</button>'
	+'</td></tr>'
	+'</table>';

var tmp_unable_user = '<div class="err user">'
		+'<h3>利用できません</h3>'
		+'<p>現在ログイン中のユーザーは、このシステムの利用を許可されていません。</p>'
		+'<button onClick="history.back()" class="btn_big">戻る</button>'
	+'</div>';

var tmp_options = '<dl>'
	+'<dt>工事一覧</dt>'
	+'<dd>'
		+'<table>'
			+'<tbody>'
				+'<tr>'
					+'<th>今期以降の表示年数</th>'
					+'<td><input type="number" name="etc_viewaddki" class="fld num" value="1" min=1 max=10>期</td>'
				+'</tr>'
			+'</tbody>'
		+'</table>'
	+'</dd>'
	+'</dl>'
	+'<dl>'
		+'<dt>計画書</dt>'
		+'<dd>'
			+'<table>'
			+'<tbody>'
				+'<tr>'
					+'<th>消費税率</th>'
					+'<td><input type="number" name="etc_taxp" class="fld num" value="10" min=0 max=30>％</td>'
				+'</tr>'
			+'</tbody>'
			+'</table>'
		+'</dd>'
	+'</dl>';
var tmp_list = '<div class="list-title">'
		+'<div id="toolbar">'
			+'<span id="pskk_caution"></span>'
			+'<button id="add_koji">'+jstr(8)+'</button>'
			+'<button id="pskk_options">システム詳細設定</button>'
			+'<button id="to_site">サイトトップへ</button>'
		+'</div>'
		+'<h3>'+jstr(5)+' <span class="now_ki">-</span> '+jstr(6)+'</h3>'
	+'</div>'
	+'<table id="pskk_list" class="tbl1">'
		+'<caption>'
			+'<div id="pskk_select_ki">'+jstr(7)+'<span></span></div>'
		+'</caption>'
		+'<thead>'
			+'<tr>'
				+'<td class="c0 key" >No</td>'
				+'<td class="c1 txt" >'+jstr(11)+'</td>'
				+'<td class="c2 cur" >'+jstr(12)+'</td>'
				+'<td class="c3 txt" >'+jstr(13)+'</td>'
				+'<td class="c4 txt" >'+jstr(14)+'</td>'
				+'<td class="c5 date">'+jstr(15)+'</td>'
				+'<td class="c6 cur" >'+jstr(16)+'</td>'
				+'<td class="c7 per" >'+jstr(17)+'</td>'
			+'</tr>'
		+'</thead>'
		+'<tbody></tbody>'
		+'<tfoot>'
			+'<tr>'
				+'<td class="c0 txt" colspan=2>'+jstr(10)+'</td>'
				+'<td class="c2 cur">0</td>'
				+'<td class="c3 txt" colspan=3></td>'
				+'<td class="c6 cur">0</td>'
				+'<td class="c7 per">0</td>'
			+'</tr>'
		+'</tfoot>'
	+'</table>'
	+'<div id="pskk_list_ftr">-</div><div id="pskk_options_area"></div>';
var tmp_jlist_all = '<table class="tbl3">'
		+'<thead>'
			+'<tr>'
				+'<th>日付</th>'
				+'<th>項目名</th>'
				+'<th>金額</th>'
				+'<th>種別</th>'
				+'<th>細別</th>'
			+'</tr>'
		+'</thead>'
		+'<tbody>'
			+'<tr>'
				+'<td colspan=6>'
					+'<center>Loading ...</center>'
				+'</td>'
			+'</tr>'
		+'</tbody>'
	+'</table>';
var tmp_detail_hdr = ''
	+'<table class="detail-hdr">'
		+'<caption>'
			+'<div id="hdr_id">No. <span class="id"></span> <span class="debug"></span></div>'
			+'<div id="pskk_navir">'
				+'<span class="stat"></span>'
				+'<button class="post">-</button>'
				//+'<button class="print">印刷</button>'
			+'</div>'
		+'</caption>'
		+'<thead>'
			+'<tr class="r1">'
				+'<th class="c1">'+jstr(23)+'</th>'
				+'<td class="c2"><input name="hdr_gst_name" class="fld text h1 list edit" tabindex=1></td>'
				+'<th class="c3">工事箇所</th>'
				+'<td class="c4"><input name="hdr_place" class="fld text h1 list edit" tabindex=3></td>'
				+'<th class="c5">契約年月日</th>'
				+'<td class="c6"><input type="tel" name="hdr_date0" class="fld date h1 edit" tabindex=6></td>'
			+'</tr>'
			+'<tr class="r2">'
				+'<th class="c1" rowspan="2">'+jstr(11)+'</th>'
				+'<td class="c2" rowspan="2"><input type="text" name="hdr_name" class="fld text h2 edit" tabindex=2></td>'
				+'<th class="c3"><div class="fl">工期</div>自</th>'
				+'<td class="c4"><input type="tel" name="hdr_date1" class="fld date h1 edit" tabindex=4></td>'
				+'<th class="c5"><div class="fl">契約金額</div>税抜</th>'
				+'<td class="c6"><input type="tel" name="hdr_kin0" class="fld cur h1 edit" tabindex=7></td>'
			+'</tr>'
			+'<tr class="r3">'
				+'<th class="c3">至</th>'
				+'<td class="c4"><input type="tel" name="hdr_date2" class="fld date h1 edit" tabindex=5></td>'
				+'<th class="c5">税込</th>'
				+'<td class="c6"><input type="text" name="hdr_kin1" class="fld bg1 cur h1" readonly></td>'
			+'</tr>'
		+'</thead>'
	+'</table>';
var tmp_detail = '<div id="pskk_detail">'
		+'<div class="detail-title">'
			+'<div id="toolbar">' // ツールバー ----------------------
				+'<button class="tolist">'+jstr(22)+'</button>'
			+'</div>'
			+'<h3>'+jstr(20)+'</h3>'
		+'</div>'
		+tmp_detail_hdr
		+'<div id="pskk_tabs" data-index=0>'
			+'<ul>'
				+'<li class="tab selected"><div>計画書</div></li>'
				+'<li class="tab"><div>実施明細一覧</div></li>'
				+'<li class="tab"><div>設定</div></li>'
			+'</ul>'
			+'<article class="selected" id="pskk_tab_main">'
				+'<table class="detail-bdy">'
					+'<tr>'
						+'<td class="vtop">'
							+'<table id="main_list">'
								+'<thead>'
									+'<tr class="r1">'
										+'<th class="c1" rowspan="2">工事<br>種別</th>'
										+'<th class="c2" rowspan="2">細別</th>'
										+'<th class="c3" colspan="2">予定</th>'
										+'<th class="c5" colspan="2">実施</th>'
									+'</tr>'
									+'<tr class="r2">'
										+'<th class="c3">項目名</th>'
										+'<th class="c4">金額</th>'
										+'<th class="c5">項目名</th>'
										+'<th class="c6">金額</th>'
									+'</tr>'
								+'</thead>'
								+'<tbody></tbody>' // <----- 明細部分
								+'<tfoot>'
									+'<tr class="r1">'
										+'<th class="c1" colspan=3>'+jstr(9)+'</th>'
										+'<td class="c2"><input name="hdr_g1" type="text" class="fld h1 bg3 cur" readonly></td>'
										+'<td class="c3"></td>'
										+'<td class="c4"><input name="hdr_g2" type="text" class="fld h1 bg3 cur" readonly></td>'
									+'</tr>'
									+'<tr class="r2">'
										+'<th class="c1" colspan="3">総工事費率</th>'
										+'<td class="c2"><input name="hdr_p1" type="text" class="fld h1 bg1 per" readonly></td>'
										+'<th class="c3">支払比率</th>'
										+'<td class="c4"><input name="hdr_p2" type="text" class="fld h1 bg1 per" readonly></td>'
									+'</tr>'
								+'</tfoot>'
							+'</table>'
						+'</td>'
						+'<td class="vtop">'
							+'<table id="nyukin_meisai">'
								+'<thead>'
									+'<tr class="r1">'
										+'<th class="c1" colspan="2">入金状況</th>'
									+'</tr>'
									+'<tr class="r2">'
										+'<th class="c1">月日</th>'
										+'<th class="c2">金額</th>'
									+'</tr>'
								+'</thead>'
								+'<tbody></tbody>'
								+'<tfoot>'
									+'<tr>'
										+'<th class="c1">'+jstr(9)+'</th>'
										+'<td class="c2">'
											+'<input type="text" name="hdr_g3" class="fld h1 bg2 cur" readonly>'
										+'</td>'
									+'</tr>'
								+'</tfoot>'
							+'</table>'
							+'<table id="bikou">'
								+'<thead>'
									+'<tr>'
										+'<td colspan=2>'
											+'<div>担当：<input type="text" name="hdr_tanto" class="fld list edit"></div>'
										+'</td>'
									+'</tr>'
								+'</thead>'
								+'<tbody>'
									+'<tr>'
										+'<td colspan=2 id="pskk_memo_area">'
											+'<textarea cols="15" rows="10" name="hdr_memo" class="fld edit"></textarea>'
										+'</td>'
									+'</tr>'
								+'</tbody>'
								+'<tfoot>'
									+'<tr>'
										+'<th class="c1">'+jstr(17)+'</th>'
										+'<td class="c2">'
											+'<input type="text" name="hdr_p3" class="fld bg1 per" readonly>'
										+'</td>'
									+'</tr>'
								+'</tfoot>'
							+'</table>'
						+'</td>'
					+'</tr>'
				+'</table>'
			+'</article>'
			+'<article>'
				+'<div id="ku1_list"></div>'
			+'</article>'
			+'<article class="options">'
				+'<div class="left">'
					+'<table id="tab_contents_etc">'
						+'<tbody>'
							+'<tr>'
								+'<th>消費税率</th>'
								+'<td><input type="number" name="hdr_taxp" class="fld num edit" size=2>％</td>'
							+'</tr>'
							+'<tr>'
								+'<th>工事状況</th>'
								+'<td>'
									+'<label><input type="checkbox" name="hdr_end" class="fld chk edit"><span>入力完了</span></label>'
								+'</td>'
							+'</tr>'
						+'</tbody>'
					+'</table>'
				+'</div>'
				+'<div class="right" id="pskk_mainte">'
					+'<button id="pskk_delkoji">工事削除</button>'
				+'</div>'
			+'</article>'
		+'</div>'
		+'<div id="listboxButton" class="popup btn">-</div>'
		+'<div id="listbox" class="popup list">-</div>'
		+'<div id="jdetailbox" class="popup"></div>'
	+'</div>';

var tmp_nyukin_meisai = function(){
	var html = ''; // 入金明細
	for(var i=0; i<29; i++){ // 入金明細数は固定(29)
		html += '<tr>'
			+'<td class="c1"><input type="text" name="nd_'+i+'" class="fld h1 list2" readonly></td>'
			+'<td class="c2"><input type="text" name="nk_'+i+'" class="fld h1 list2 cur" readonly></td>'
			+'</tr>';
	}
	return html;
}

var tmp_kssb = function(syu, st_index){
	var html = '';
	cur_index = st_index;
	$.each(syu, function(index, v){
		html += _ks(v);
	});
	return html;
	function _ks(syu){
		var sp = [1,1,1,3]; // 各種別の余白行（現在固定）
		var su = syu['sb'].length + sp[ syu['code'] ];
		var na = _tate(syu['name']); // 文字間に<br>を入れる
		var html = '<tr class="total">'
			+'<td class="c1" rowspan="'+(su+1)+'">'+na+'</th>' // 
			+'<td class="c2"></td>'
			+'<td class="c3"></td>'
			+'<td class="c4"><input type="text" name="total_y_'+syu['code']+'" class="fld h1 bg2 cur" readonly></td>'
			+'<td class="c5"></td>'
			+'<td class="c6"><input type="text" name="total_j_'+syu['code']+'" class="fld h1 bg2 cur" readonly></td>'
			+'</tr>';
		for(var i=0; i<su; i++){
			var v = (syu['sb'][i]===undefined) ? '' : syu['sb'][i]['name'];
			var n0 = ' type="text" name="m_c0_'+syu['code']+'_'+i+'"';
			var n1 = ' type="text" name="m_c1_'+syu['code']+'_'+i+'"';
			var n2 = ' type="tel"  name="m_c2_'+syu['code']+'_'+i+'"';
			var n3 = ' type="text" name="m_c3_'+syu['code']+'_'+i+'"';
			var n4 = ' type="text" name="m_c4_'+syu['code']+'_'+i+'"';
			html += '<tr class="items">'
			+'<td class="c2"><input'+n0+' class="fld h1 text bg1 edit" value="'+v+'" data-ksname="'+syu['name']+'"></td>'
			+'<td class="c3"><input'+n1+' class="fld h1 text list edit" tabindex='+(cur_index++)+'></td>'
			+'<td class="c4"><input'+n2+' class="fld h1 cur edit" tabindex='+(cur_index++)+'></td>'
			+'<td class="c5"><input'+n3+' class="fld h1 bg1 list2" readonly></td>'
			+'<td class="c6"><input'+n4+' class="fld h1 bg1 list2 cur" readonly></td>'
			+'</tr>';
		}
		return html;
		function _tate(str){
			var d = new Array();
			for(var i= 0; i<str.length; i++){
				d[i] = str.substr(i,1);
			}
			return d.join('<br>');
		}
	}
}

var tmp_jDetail = '<div class="fbtn close_btn">×</div>'
	+'<table class="meisaiDetail">'
		+'<caption></caption>'
		+'<thead><tr><td colspan=2>'
			+'<div class="del"><input type="checkbox" class="del"> 削除</div>'
			+'<div class="stat"><span class="id"></span>:<span class="ks"></span>-<span class="sb"></span></div></div>'
		+'</td></tr></thead>'
		+'<tbody>'
			+'<tr><th>日付</th><td><input type="text" name="dat" class="fld fdat h1 date"></td></tr>'
			+'<tr><th>項目</th><td><input type="text" name="kou" class="fld fkou h1 text"></td></tr>'
			+'<tr><th>金額</th><td><input type="tel"  name="kin" class="fld fkin h1 cur"></td></tr>'
		+'</tbody>'
		+'<tfoot>'
			+'<tr>'
				+'<td colspan=2>'
					+'<div class="select"></div>'
					+'<button class="post"></button>'
				+'</td>'
			+'</tr>'
		+'</tfoot>'
	+'</table>';
